/*
 * Decompiled with CFR 0.152.
 */
package com.epam.atg.gradle.build.repository;

import com.epam.atg.gradle.build.ATGGradleProject;
import com.epam.atg.gradle.build.module.ATGModule;
import com.epam.atg.gradle.build.module.ATGProjectModule;
import com.epam.atg.gradle.build.repository.ATGRepository;
import com.epam.atg.gradle.build.utils.ManifestUtils;
import com.epam.atg.gradle.utils.ProjectUtils;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Manifest;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ATGRepositoryImpl
implements ATGRepository,
GroovyObject {
    private static final Logger LOGGER;
    private File atgRoot;
    private Map<String, ATGModule> modulesMap;
    private Map<String, String> installUnitFoldersMap;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ATGRepositoryImpl() {
        MetaClass metaClass;
        CallSite[] callSiteArray = ATGRepositoryImpl.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void initializeRepository() {
        CallSite[] callSiteArray = ATGRepositoryImpl.$getCallSiteArray();
        callSiteArray[0].call((Object)LOGGER, (Object)"Initializing ATGRepository");
        Object object = callSiteArray[1].callConstructor(ConcurrentHashMap.class);
        this.modulesMap = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        Object object2 = callSiteArray[2].callConstructor(HashMap.class);
        this.installUnitFoldersMap = (Map)ScriptBytecodeAdapter.castToType((Object)object2, Map.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[3].callCurrent((GroovyObject)this);
        } else {
            this.scanInstalledModules();
        }
    }

    private void scanInstalledModules() {
        CallSite[] callSiteArray = ATGRepositoryImpl.$getCallSiteArray();
        public class _scanInstalledModules_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _scanInstalledModules_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _scanInstalledModules_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object dir) {
                CallSite[] callSiteArray = _scanInstalledModules_closure1.$getCallSiteArray();
                Manifest manifest = (Manifest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(ManifestUtils.class, dir), Manifest.class);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)manifest, null)) {
                    String installUnit = ShortTypeHandling.castToString((Object)callSiteArray[1].call(ManifestUtils.class, (Object)manifest));
                    if (DefaultTypeTransformation.booleanUnbox((Object)installUnit)) {
                        return callSiteArray[2].callCurrent((GroovyObject)this, (Object)installUnit, callSiteArray[3].callGetProperty(dir));
                    }
                    return null;
                }
                return null;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _scanInstalledModules_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "findManifestInModuleDirectory";
                stringArray[1] = "getInstalledUnit";
                stringArray[2] = "mapInstallUnitToModuleFolder";
                stringArray[3] = "absolutePath";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _scanInstalledModules_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_scanInstalledModules_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _scanInstalledModules_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[4].call((Object)this.atgRoot, (Object)new _scanInstalledModules_closure1(this, this));
    }

    private void mapInstallUnitToModuleFolder(String moduleName, String installedModulePath) {
        CallSite[] callSiteArray = ATGRepositoryImpl.$getCallSiteArray();
        callSiteArray[5].call(this.installUnitFoldersMap, (Object)moduleName, (Object)installedModulePath);
    }

    private boolean isInstalledModule(String moduleName) {
        CallSite[] callSiteArray = ATGRepositoryImpl.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].call(this.installUnitFoldersMap, (Object)moduleName));
    }

    private String getInstalledModuleRelativeFolder(String moduleName) {
        CallSite[] callSiteArray = ATGRepositoryImpl.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[7].call(this.installUnitFoldersMap, (Object)moduleName));
    }

    private void addModule(ATGModule module) {
        CallSite[] callSiteArray = ATGRepositoryImpl.$getCallSiteArray();
        callSiteArray[8].call(this.modulesMap, callSiteArray[9].callGroovyObjectGetProperty((Object)module), (Object)module);
    }

    private ATGModule findModule(String module) {
        CallSite[] callSiteArray = ATGRepositoryImpl.$getCallSiteArray();
        return (ATGModule)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].call(this.modulesMap, (Object)module), ATGModule.class);
    }

    @Override
    public ATGProjectModule getProjectATGModule(ATGGradleProject atgGradleProject) {
        CallSite[] callSiteArray = ATGRepositoryImpl.$getCallSiteArray();
        String moduleName = ShortTypeHandling.castToString((Object)callSiteArray[11].call((Object)atgGradleProject));
        callSiteArray[12].call((Object)LOGGER, (Object)"Project {} has module name: {}", (Object)atgGradleProject, (Object)moduleName);
        ATGModule atgModule = (ATGModule)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].callCurrent((GroovyObject)this, callSiteArray[14].callGroovyObjectGetProperty((Object)atgGradleProject), (Object)moduleName), ATGModule.class);
        if (atgModule instanceof ATGProjectModule) {
            return (ATGProjectModule)ScriptBytecodeAdapter.castToType((Object)atgModule, ATGProjectModule.class);
        }
        callSiteArray[15].call((Object)LOGGER, (Object)"Module {} is not ATGProjectModule", (Object)moduleName);
        return (ATGProjectModule)ScriptBytecodeAdapter.castToType(null, ATGProjectModule.class);
    }

    @Override
    public ATGModule getATGModule(Project project, String moduleName) {
        CallSite[] callSiteArray = ATGRepositoryImpl.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)moduleName)) {
            callSiteArray[16].call((Object)LOGGER, (Object)"Unable to get module with null moduleName for project: {}", (Object)project);
            return (ATGModule)ScriptBytecodeAdapter.castToType(null, ATGModule.class);
        }
        ATGModule atgModule = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[17].callCurrent((GroovyObject)this, (Object)moduleName);
            atgModule = (ATGModule)ScriptBytecodeAdapter.castToType((Object)object, ATGModule.class);
        } else {
            ATGModule aTGModule;
            atgModule = aTGModule = this.findModule(moduleName);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)atgModule, null)) {
            return atgModule;
        }
        Project atgRootGradleProjectForModule = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].call(ProjectUtils.class, (Object)moduleName, (Object)project), Project.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)atgRootGradleProjectForModule)) {
                Object object = callSiteArray[19].callCurrent((GroovyObject)this, (Object)moduleName, (Object)atgRootGradleProjectForModule);
                atgModule = (ATGModule)ScriptBytecodeAdapter.castToType((Object)object, ATGModule.class);
            } else {
                Object object = callSiteArray[20].callCurrent((GroovyObject)this, (Object)moduleName);
                atgModule = (ATGModule)ScriptBytecodeAdapter.castToType((Object)object, ATGModule.class);
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)atgRootGradleProjectForModule)) {
            Object object = callSiteArray[21].callCurrent((GroovyObject)this, (Object)moduleName, (Object)atgRootGradleProjectForModule);
            atgModule = (ATGModule)ScriptBytecodeAdapter.castToType((Object)object, ATGModule.class);
        } else {
            ATGModule aTGModule;
            atgModule = aTGModule = this.createOutOfTheBoxAtgModule(moduleName);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)atgModule, null)) {
            callSiteArray[22].call((Object)LOGGER, (Object)"Could not find module {}", (Object)moduleName);
            return (ATGModule)ScriptBytecodeAdapter.castToType(null, ATGModule.class);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[23].call((Object)atgModule))) {
            callSiteArray[24].call((Object)LOGGER, (Object)"{} atg module not valid and will be skipped.", (Object)project);
            return (ATGModule)ScriptBytecodeAdapter.castToType(null, ATGModule.class);
        }
        callSiteArray[25].callCurrent((GroovyObject)this, (Object)atgModule);
        return atgModule;
    }

    @Override
    public List<String> getDependencies(String moduleName) {
        CallSite[] callSiteArray = ATGRepositoryImpl.$getCallSiteArray();
        ATGModule module = (ATGModule)ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].call(this.modulesMap, (Object)moduleName), ATGModule.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)module, null)) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].call(callSiteArray[28].callGroovyObjectGetProperty((Object)module)), List.class);
    }

    private ATGModule createCustomAtgModule(String moduleName, Project atgRootGradleProjectForModule) {
        CallSite[] callSiteArray = ATGRepositoryImpl.$getCallSiteArray();
        ATGModule module = null;
        callSiteArray[29].call((Object)LOGGER, (Object)"Module {} is part of the {}", (Object)moduleName, (Object)atgRootGradleProjectForModule);
        File atgRootProjectDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].callGetProperty((Object)atgRootGradleProjectForModule), File.class);
        String atgRootModuleName = ShortTypeHandling.castToString((Object)callSiteArray[31].call(ProjectUtils.class, (Object)atgRootGradleProjectForModule));
        String projectRelativeModuleName = ShortTypeHandling.castToString((Object)callSiteArray[32].call(ProjectUtils.class, (Object)moduleName, (Object)atgRootModuleName));
        String relativePath = ShortTypeHandling.castToString((Object)callSiteArray[33].call(ManifestUtils.class, (Object)projectRelativeModuleName));
        File moduleLocation = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].callConstructor(File.class, callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].callGetProperty((Object)atgRootProjectDir), callSiteArray[38].callGetProperty(File.class)), (Object)relativePath)), File.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[39].call((Object)moduleLocation))) {
            Project moduleGradleProject = (Project)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].call(ProjectUtils.class, (Object)moduleLocation, (Object)atgRootGradleProjectForModule), Project.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)moduleGradleProject)) {
                Object object = callSiteArray[41].callConstructor(ATGProjectModule.class, (Object)moduleName, (Object)moduleLocation, (Object)moduleGradleProject);
                module = (ATGModule)ScriptBytecodeAdapter.castToType((Object)object, ATGModule.class);
            } else {
                callSiteArray[42].call((Object)LOGGER, (Object)"Project {} not handled by gradle", (Object)moduleLocation);
                Object object = callSiteArray[43].callConstructor(ATGModule.class, (Object)moduleName, (Object)moduleLocation);
                module = (ATGModule)ScriptBytecodeAdapter.castToType((Object)object, ATGModule.class);
            }
        } else {
            callSiteArray[44].call((Object)LOGGER, (Object)"Module location {} does not exist", (Object)moduleLocation);
        }
        if (ScriptBytecodeAdapter.compareEqual(module, null)) {
            callSiteArray[45].call((Object)LOGGER, (Object)"Module does not exist in location {}", (Object)moduleLocation);
        }
        return module;
    }

    private ATGModule createOutOfTheBoxAtgModule(String moduleName) {
        CallSite[] callSiteArray = ATGRepositoryImpl.$getCallSiteArray();
        ATGModule module = null;
        File moduleLocation = null;
        callSiteArray[46].call((Object)LOGGER, (Object)"Module {} is ATG module", (Object)moduleName);
        String rootModuleName = ShortTypeHandling.castToString((Object)callSiteArray[47].call(ManifestUtils.class, (Object)moduleName));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].callCurrent((GroovyObject)this, (Object)rootModuleName))) {
                String installedModulePath = ShortTypeHandling.castToString((Object)callSiteArray[49].callCurrent((GroovyObject)this, (Object)rootModuleName));
                Object object = callSiteArray[50].callConstructor(File.class, callSiteArray[51].call(callSiteArray[52].call((Object)installedModulePath, callSiteArray[53].callGetProperty(File.class)), callSiteArray[54].call(ManifestUtils.class, (Object)moduleName)));
                moduleLocation = (File)ScriptBytecodeAdapter.castToType((Object)object, File.class);
            } else {
                Object object = callSiteArray[55].callConstructor(File.class, callSiteArray[56].call(callSiteArray[57].call(callSiteArray[58].callGetProperty((Object)this.atgRoot), callSiteArray[59].callGetProperty(File.class)), callSiteArray[60].call(ManifestUtils.class, (Object)moduleName)));
                moduleLocation = (File)ScriptBytecodeAdapter.castToType((Object)object, File.class);
            }
        } else if (this.isInstalledModule(rootModuleName)) {
            String installedModulePath = this.getInstalledModuleRelativeFolder(rootModuleName);
            Object object = callSiteArray[61].callConstructor(File.class, callSiteArray[62].call(callSiteArray[63].call((Object)installedModulePath, callSiteArray[64].callGetProperty(File.class)), callSiteArray[65].call(ManifestUtils.class, (Object)moduleName)));
            moduleLocation = (File)ScriptBytecodeAdapter.castToType((Object)object, File.class);
        } else {
            Object object = callSiteArray[66].callConstructor(File.class, callSiteArray[67].call(callSiteArray[68].call(callSiteArray[69].callGetProperty((Object)this.atgRoot), callSiteArray[70].callGetProperty(File.class)), callSiteArray[71].call(ManifestUtils.class, (Object)moduleName)));
            moduleLocation = (File)ScriptBytecodeAdapter.castToType((Object)object, File.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[72].call((Object)moduleLocation))) {
            Object object = callSiteArray[73].callConstructor(ATGModule.class, (Object)moduleName, (Object)moduleLocation);
            module = (ATGModule)ScriptBytecodeAdapter.castToType((Object)object, ATGModule.class);
        }
        if (ScriptBytecodeAdapter.compareEqual(module, null)) {
            callSiteArray[74].call((Object)LOGGER, (Object)"Module does not exist in location {}", (Object)moduleLocation);
        }
        return module;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ATGRepositoryImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = ATGRepositoryImpl.$getCallSiteArray()[75].call(LoggerFactory.class, ATGRepositoryImpl.class);
        LOGGER = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "info";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "scanInstalledModules";
        stringArray[4] = "eachDir";
        stringArray[5] = "put";
        stringArray[6] = "containsKey";
        stringArray[7] = "get";
        stringArray[8] = "put";
        stringArray[9] = "name";
        stringArray[10] = "get";
        stringArray[11] = "calculateAtgModuleName";
        stringArray[12] = "debug";
        stringArray[13] = "getATGModule";
        stringArray[14] = "project";
        stringArray[15] = "error";
        stringArray[16] = "warn";
        stringArray[17] = "findModule";
        stringArray[18] = "findAtgRootProjectForModule";
        stringArray[19] = "createCustomAtgModule";
        stringArray[20] = "createOutOfTheBoxAtgModule";
        stringArray[21] = "createCustomAtgModule";
        stringArray[22] = "warn";
        stringArray[23] = "initialize";
        stringArray[24] = "warn";
        stringArray[25] = "addModule";
        stringArray[26] = "getAt";
        stringArray[27] = "asImmutable";
        stringArray[28] = "requiredModules";
        stringArray[29] = "debug";
        stringArray[30] = "projectDir";
        stringArray[31] = "getAtgRootModuleName";
        stringArray[32] = "getModuleProjectRelativeName";
        stringArray[33] = "convertModuleNameToRelativePath";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "plus";
        stringArray[36] = "plus";
        stringArray[37] = "absolutePath";
        stringArray[38] = "separator";
        stringArray[39] = "exists";
        stringArray[40] = "findModuleProject";
        stringArray[41] = "<$constructor$>";
        stringArray[42] = "debug";
        stringArray[43] = "<$constructor$>";
        stringArray[44] = "warn";
        stringArray[45] = "warn";
        stringArray[46] = "debug";
        stringArray[47] = "getRootModuleFromModuleName";
        stringArray[48] = "isInstalledModule";
        stringArray[49] = "getInstalledModuleRelativeFolder";
        stringArray[50] = "<$constructor$>";
        stringArray[51] = "plus";
        stringArray[52] = "plus";
        stringArray[53] = "separator";
        stringArray[54] = "convertModuleNameToRelativePath";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "plus";
        stringArray[57] = "plus";
        stringArray[58] = "absolutePath";
        stringArray[59] = "separator";
        stringArray[60] = "convertModuleNameToRelativePath";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "plus";
        stringArray[63] = "plus";
        stringArray[64] = "separator";
        stringArray[65] = "convertModuleNameToRelativePath";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "plus";
        stringArray[68] = "plus";
        stringArray[69] = "absolutePath";
        stringArray[70] = "separator";
        stringArray[71] = "convertModuleNameToRelativePath";
        stringArray[72] = "exists";
        stringArray[73] = "<$constructor$>";
        stringArray[74] = "warn";
        stringArray[75] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[76];
        ATGRepositoryImpl.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ATGRepositoryImpl.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ATGRepositoryImpl.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

