/*
 * Decompiled with CFR 0.152.
 */
package com.epages.restdocs.apispec;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.restdocs.headers.AbstractHeadersSnippet;
import org.springframework.restdocs.headers.HeaderDescriptor;
import org.springframework.restdocs.hypermedia.LinkDescriptor;
import org.springframework.restdocs.hypermedia.LinksSnippet;
import org.springframework.restdocs.payload.AbstractFieldsSnippet;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.request.AbstractParametersSnippet;
import org.springframework.restdocs.request.ParameterDescriptor;
import org.springframework.restdocs.snippet.AbstractDescriptor;
import org.springframework.restdocs.snippet.Snippet;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u000e\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\u0006\u0010\u0007\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u0007\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00042\u0006\u0010\u0007\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00042\u0006\u0010\u0007\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/epages/restdocs/apispec/DescriptorExtractor;", "", "()V", "extractDescriptorsFor", "", "T", "Lorg/springframework/restdocs/snippet/AbstractDescriptor;", "snippet", "Lorg/springframework/restdocs/snippet/Snippet;", "extractFields", "Lorg/springframework/restdocs/payload/FieldDescriptor;", "Lorg/springframework/restdocs/payload/AbstractFieldsSnippet;", "extractHeaders", "Lorg/springframework/restdocs/headers/HeaderDescriptor;", "Lorg/springframework/restdocs/headers/AbstractHeadersSnippet;", "extractLinks", "Lorg/springframework/restdocs/hypermedia/LinkDescriptor;", "Lorg/springframework/restdocs/hypermedia/LinksSnippet;", "extractParameters", "Lorg/springframework/restdocs/request/ParameterDescriptor;", "Lorg/springframework/restdocs/request/AbstractParametersSnippet;", "restdocs-api-spec"})
public final class DescriptorExtractor {
    public static final DescriptorExtractor INSTANCE;

    @NotNull
    public final <T extends AbstractDescriptor<T>> List<T> extractDescriptorsFor(@NotNull Snippet snippet) {
        List<Object> list;
        Intrinsics.checkParameterIsNotNull((Object)snippet, (String)"snippet");
        Snippet snippet2 = snippet;
        if (snippet2 instanceof AbstractFieldsSnippet) {
            list = this.extractFields((AbstractFieldsSnippet)snippet);
            if (list == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<T>");
            }
        } else if (snippet2 instanceof LinksSnippet) {
            list = this.extractLinks((LinksSnippet)snippet);
            if (list == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<T>");
            }
        } else if (snippet2 instanceof AbstractHeadersSnippet) {
            list = this.extractHeaders((AbstractHeadersSnippet)snippet);
            if (list == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<T>");
            }
        } else if (snippet2 instanceof AbstractParametersSnippet) {
            list = this.extractParameters((AbstractParametersSnippet)snippet);
            if (list == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<T>");
            }
        } else {
            List list2 = Collections.emptyList();
            list = list2;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"emptyList()");
        }
        return list;
    }

    private final List<FieldDescriptor> extractFields(AbstractFieldsSnippet snippet) {
        try {
            Method getFieldDescriptors;
            Method method = getFieldDescriptors = AbstractFieldsSnippet.class.getDeclaredMethod("getFieldDescriptors", new Class[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"getFieldDescriptors");
            method.setAccessible(true);
            Object object = getFieldDescriptors.invoke((Object)snippet, new Object[0]);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<org.springframework.restdocs.payload.FieldDescriptor>");
            }
            return (List)object;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        List<FieldDescriptor> list = Collections.emptyList();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"emptyList()");
        return list;
    }

    private final List<LinkDescriptor> extractLinks(LinksSnippet snippet) {
        try {
            Method getDescriptorsByRel;
            Method method = getDescriptorsByRel = LinksSnippet.class.getDeclaredMethod("getDescriptorsByRel", new Class[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"getDescriptorsByRel");
            method.setAccessible(true);
            Object object = getDescriptorsByRel.invoke((Object)snippet, new Object[0]);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.springframework.restdocs.hypermedia.LinkDescriptor>");
            }
            return CollectionsKt.toList((Iterable)((Map)object).values());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        List<LinkDescriptor> list = Collections.emptyList();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"emptyList()");
        return list;
    }

    private final List<HeaderDescriptor> extractHeaders(AbstractHeadersSnippet snippet) {
        try {
            Method getHeaderDescriptors;
            Method method = getHeaderDescriptors = AbstractHeadersSnippet.class.getDeclaredMethod("getHeaderDescriptors", new Class[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"getHeaderDescriptors");
            method.setAccessible(true);
            Object object = getHeaderDescriptors.invoke((Object)snippet, new Object[0]);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<org.springframework.restdocs.headers.HeaderDescriptor>");
            }
            return (List)object;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        List<HeaderDescriptor> list = Collections.emptyList();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"emptyList()");
        return list;
    }

    private final List<ParameterDescriptor> extractParameters(AbstractParametersSnippet snippet) {
        try {
            Method getParameterDescriptors;
            Method method = getParameterDescriptors = AbstractParametersSnippet.class.getDeclaredMethod("getParameterDescriptors", new Class[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"getParameterDescriptors");
            method.setAccessible(true);
            Object object = getParameterDescriptors.invoke((Object)snippet, new Object[0]);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.springframework.restdocs.request.ParameterDescriptor>");
            }
            return new ArrayList(((Map)object).values());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        List<ParameterDescriptor> list = Collections.emptyList();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"emptyList()");
        return list;
    }

    private DescriptorExtractor() {
    }

    static {
        DescriptorExtractor descriptorExtractor;
        INSTANCE = descriptorExtractor = new DescriptorExtractor();
    }
}

