/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client.body;

import java.io.InputStream;
import java.util.Optional;
import java.util.function.Supplier;

public final class Body {
    private final Supplier<InputStream> inputStream;
    private final String contentType;

    public static Body bodyWithoutContentType(Supplier<InputStream> inputStream) {
        return new Body(inputStream, null);
    }

    public static Body bodyWithContentType(Supplier<InputStream> inputStream, String contentType) {
        return new Body(inputStream, contentType);
    }

    public InputStream inputStream() {
        return this.inputStream.get();
    }

    public Optional<String> contentType() {
        return Optional.ofNullable(this.contentType);
    }

    private Body(Supplier<InputStream> inputStream, String contentType) {
        this.inputStream = inputStream;
        this.contentType = contentType;
    }
}

