/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client;

import com.envimate.httpmate.util.Validators;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;

public final class UriString {
    private final String value;

    public static UriString uriString(String value) {
        Validators.validateNotNull((Object)value, (String)"value");
        return new UriString(value);
    }

    public String encoded(Function<String, String> encoder) {
        return encoder.apply(this.value);
    }

    public String encoded() {
        return this.encoded(UriString::urlEncode);
    }

    public String unencoded() {
        return this.value;
    }

    private static String urlEncode(String string) {
        return URLEncoder.encode(string, StandardCharsets.UTF_8);
    }

    public String toString() {
        return "UriString(value=" + this.value + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UriString)) {
            return false;
        }
        UriString other = (UriString)o;
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    private UriString(String value) {
        this.value = value;
    }
}

