/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client;

import com.envimate.httpmate.client.BasePath;
import com.envimate.httpmate.client.HeaderKey;
import com.envimate.httpmate.client.HeaderValue;
import com.envimate.httpmate.client.HttpClientRequest;
import com.envimate.httpmate.client.QueryParameter;
import com.envimate.httpmate.client.RequestPath;
import com.envimate.httpmate.client.SimpleHttpResponseObject;
import com.envimate.httpmate.client.body.Body;
import com.envimate.httpmate.client.body.multipart.MultipartBodyCreator;
import com.envimate.httpmate.client.body.multipart.Part;
import com.envimate.httpmate.util.Streams;
import com.envimate.httpmate.util.Validators;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;

public final class HttpClientRequestBuilder<T> {
    private final String method;
    private final RequestPath path;
    private Body body;
    private final Map<HeaderKey, HeaderValue> headers = new HashMap<HeaderKey, HeaderValue>();
    private Class<T> targetType;

    static HttpClientRequestBuilder<SimpleHttpResponseObject> httpClientRequestBuilderImplementation(String method, String path) {
        Validators.validateNotNullNorEmpty((String)method, (String)"method");
        Validators.validateNotNull((Object)path, (String)"path");
        RequestPath requestPath = RequestPath.parse(path);
        HttpClientRequestBuilder httpClientRequestBuilder = new HttpClientRequestBuilder(method, requestPath);
        return httpClientRequestBuilder.mappedTo(SimpleHttpResponseObject.class);
    }

    public HttpClientRequestBuilder<T> withAMultipartBodyWithTheParts(Part ... parts) {
        return this.withTheBody(MultipartBodyCreator.createMultipartBody(parts));
    }

    public HttpClientRequestBuilder<T> withTheBody(String body) {
        return this.withTheBody(Streams.stringToInputStream((String)body));
    }

    public HttpClientRequestBuilder<T> withTheBody(InputStream body) {
        return this.withTheBody(Body.bodyWithoutContentType(() -> body));
    }

    public HttpClientRequestBuilder<T> withTheBody(Body body) {
        this.body = body;
        return this;
    }

    public HttpClientRequestBuilder<T> withContentType(String contentType) {
        return this.withHeader("Content-type", contentType);
    }

    public HttpClientRequestBuilder<T> withHeader(String key, String value) {
        HeaderKey headerKey = HeaderKey.headerKey(key);
        HeaderValue headerValue = HeaderValue.headerValue(value);
        this.headers.put(headerKey, headerValue);
        return this;
    }

    public HttpClientRequestBuilder<T> withQueryParameter(String key) {
        this.path.add(QueryParameter.queryParameter(key));
        return this;
    }

    public HttpClientRequestBuilder<T> withQueryParameter(String key, String value) {
        this.path.add(QueryParameter.queryParameter(key, value));
        return this;
    }

    public HttpClientRequestBuilder<String> mappedToString() {
        return this.mappedTo(String.class);
    }

    public <X> HttpClientRequestBuilder<X> mappedTo(Class<X> targetType) {
        this.targetType = targetType;
        return this;
    }

    HttpClientRequest<T> build(BasePath basePath) {
        return HttpClientRequest.httpClientRequest(this.path, this.method, this.headers, Optional.ofNullable(this.body), this.targetType);
    }

    private static String createQuery(Map<String, String> queryParameters) {
        if (queryParameters.isEmpty()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner("&", "?", "");
        queryParameters.forEach((key, value) -> joiner.add(key + "=" + value));
        return joiner.toString();
    }

    private HttpClientRequestBuilder(String method, RequestPath path) {
        this.method = method;
        this.path = path;
    }
}

