/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client;

import com.envimate.httpmate.client.HeaderKey;
import com.envimate.httpmate.client.HeaderValue;
import com.envimate.httpmate.client.HttpClientRequestBuilder;
import com.envimate.httpmate.client.Query;
import com.envimate.httpmate.client.QueryParameterKey;
import com.envimate.httpmate.client.QueryParameterValue;
import com.envimate.httpmate.client.SimpleHttpResponseObject;
import com.envimate.httpmate.client.body.Body;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class HttpClientRequest<T> {
    private final String path;
    private final String method;
    private final Map<HeaderKey, HeaderValue> headers;
    private final Map<QueryParameterKey, QueryParameterValue> queryParameters;
    private final InputStream body;
    private final Class<T> targetType;

    public static HttpClientRequestBuilder<SimpleHttpResponseObject> aGetRequestToThePath(String path) {
        return HttpClientRequest.aRequest("GET", path);
    }

    public static HttpClientRequestBuilder<SimpleHttpResponseObject> aPostRequestToThePath(String path) {
        return HttpClientRequest.aRequest("POST", path);
    }

    public static HttpClientRequestBuilder<SimpleHttpResponseObject> aPutRequestToThePath(String path) {
        return HttpClientRequest.aRequest("PUT", path);
    }

    public static HttpClientRequestBuilder<SimpleHttpResponseObject> aDeleteRequestToThePath(String path) {
        return HttpClientRequest.aRequest("DELETE", path);
    }

    public static HttpClientRequestBuilder<SimpleHttpResponseObject> anOptionsRequestToThePath(String path) {
        return HttpClientRequest.aRequest("OPTIONS", path);
    }

    public static HttpClientRequestBuilder<SimpleHttpResponseObject> aRequest(String method, String path) {
        return HttpClientRequestBuilder.httpClientRequestBuilderImplementation(method, path);
    }

    static <T> HttpClientRequest<T> httpClientRequest(String pathWithEncodedQueryParameters, String method, Map<HeaderKey, HeaderValue> headers, Map<QueryParameterKey, QueryParameterValue> explicitQueryParameters, Optional<Body> bodyOptional, Class<T> targetType) {
        InputStream bodyStream;
        Query query = Query.parse(pathWithEncodedQueryParameters);
        HashMap<QueryParameterKey, QueryParameterValue> allQueryParameters = new HashMap<QueryParameterKey, QueryParameterValue>();
        allQueryParameters.putAll(query.encodedQueryParameters());
        allQueryParameters.putAll(explicitQueryParameters);
        String pathWithoutEncodedQueryParameters = query.path();
        HashMap<HeaderKey, HeaderValue> fixedHeaders = new HashMap<HeaderKey, HeaderValue>(headers);
        if (bodyOptional.isPresent()) {
            Body body = bodyOptional.get();
            body.contentType().ifPresent(contentType -> fixedHeaders.put(HeaderKey.headerKey("Content-Type"), HeaderValue.headerValue(contentType)));
            bodyStream = body.inputStream();
        } else {
            bodyStream = null;
        }
        return new HttpClientRequest<T>(pathWithoutEncodedQueryParameters, method, fixedHeaders, allQueryParameters, bodyStream, targetType);
    }

    public String path() {
        return this.path;
    }

    public String method() {
        return this.method;
    }

    public Map<String, String> headers() {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        this.headers.forEach((key, value) -> stringMap.put(key.value(), value.value()));
        return stringMap;
    }

    public Map<String, String> queryParameters() {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        this.queryParameters.forEach((key, value) -> stringMap.put(key.value(), value.value()));
        return stringMap;
    }

    public Optional<InputStream> body() {
        return Optional.ofNullable(this.body);
    }

    Class<T> targetType() {
        return this.targetType;
    }

    private HttpClientRequest(String path, String method, Map<HeaderKey, HeaderValue> headers, Map<QueryParameterKey, QueryParameterValue> queryParameters, InputStream body, Class<T> targetType) {
        this.path = path;
        this.method = method;
        this.headers = headers;
        this.queryParameters = queryParameters;
        this.body = body;
        this.targetType = targetType;
    }
}

