/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client.issuer.real;

import com.envimate.httpmate.client.issuer.real.Connection;
import com.envimate.httpmate.client.issuer.real.ConnectionFactory;
import com.envimate.httpmate.client.issuer.real.Endpoint;
import com.envimate.httpmate.client.issuer.real.NormalConnection;
import java.io.IOException;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpHost;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.pool.BasicConnFactory;

public final class NormalConnectionFactory
implements ConnectionFactory {
    private final BasicConnFactory basicConnFactory;

    static ConnectionFactory normalConnectionFactory() {
        BasicConnFactory basicConnFactory = new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT);
        return new NormalConnectionFactory(basicConnFactory);
    }

    @Override
    public Connection getConnectionTo(Endpoint endpoint) {
        HttpHost target = new HttpHost(endpoint.host(), endpoint.port(), endpoint.protocol().identifier());
        try {
            HttpClientConnection connection = this.basicConnFactory.create(target);
            return NormalConnection.normalConnection(connection);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private NormalConnectionFactory(BasicConnFactory basicConnFactory) {
        this.basicConnFactory = basicConnFactory;
    }
}

