/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client;

import com.envimate.httpmate.client.QueryParameterKey;
import com.envimate.httpmate.client.QueryParameterValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

final class Query {
    private final String path;
    private final Map<QueryParameterKey, QueryParameterValue> encodedQueryParameters;

    static Query parse(String query) {
        String[] pathAndQueryParameters = query.split("\\?");
        String path = pathAndQueryParameters[0];
        HashMap<QueryParameterKey, QueryParameterValue> encodedQueryParameters = new HashMap<QueryParameterKey, QueryParameterValue>();
        if (pathAndQueryParameters.length > 1) {
            String queryParamters = pathAndQueryParameters[1];
            String[] queryParametersArray = queryParamters.split("&");
            Arrays.stream(queryParametersArray).forEach(element -> {
                String[] keyValue = element.split("=");
                QueryParameterKey key = QueryParameterKey.queryParameterKey(keyValue[0]);
                QueryParameterValue value = keyValue.length > 1 ? QueryParameterValue.queryParameterValue(keyValue[1]) : QueryParameterValue.queryParameterValue("");
                encodedQueryParameters.put(key, value);
            });
        }
        return new Query(path, encodedQueryParameters);
    }

    String path() {
        return this.path;
    }

    Map<QueryParameterKey, QueryParameterValue> encodedQueryParameters() {
        return this.encodedQueryParameters;
    }

    private Query(String path, Map<QueryParameterKey, QueryParameterValue> encodedQueryParameters) {
        this.path = path;
        this.encodedQueryParameters = encodedQueryParameters;
    }
}

