/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client;

import com.envimate.httpmate.client.HeaderKey;
import com.envimate.httpmate.client.HeaderValue;
import com.envimate.httpmate.client.HttpClientRequestBuilder;
import com.envimate.httpmate.client.Query;
import com.envimate.httpmate.client.QueryParameterKey;
import com.envimate.httpmate.client.QueryParameterValue;
import com.envimate.httpmate.client.requestbuilder.Body;
import com.envimate.httpmate.client.requestbuilder.PathStage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public final class HttpClientRequest<T> {
    private final String path;
    private final String method;
    private final Map<HeaderKey, HeaderValue> headers;
    private final Map<QueryParameterKey, QueryParameterValue> queryParameters;
    private final InputStream body;
    private final Class<T> targetType;

    public static PathStage aGetRequest() {
        return HttpClientRequest.aRequestOfTheMethod("GET");
    }

    public static PathStage aPostRequest() {
        return HttpClientRequest.aRequestOfTheMethod("POST");
    }

    public static PathStage aPutRequest() {
        return HttpClientRequest.aRequestOfTheMethod("PUT");
    }

    public static PathStage aDeleteRequest() {
        return HttpClientRequest.aRequestOfTheMethod("DELETE");
    }

    public static PathStage aOptionsRequest() {
        return HttpClientRequest.aRequestOfTheMethod("OPTIONS");
    }

    public static PathStage aRequestOfTheMethod(String method) {
        return HttpClientRequestBuilder.httpClientRequestBuilderImplementation(method);
    }

    static <T> HttpClientRequest<T> httpClientRequest(String pathWithEncodedQueryParameters, String method, Map<HeaderKey, HeaderValue> headers, Map<QueryParameterKey, QueryParameterValue> explicitQueryParameters, Body body, Class<T> targetType) {
        Query query = Query.parse(pathWithEncodedQueryParameters);
        HashMap<QueryParameterKey, QueryParameterValue> allQueryParameters = new HashMap<QueryParameterKey, QueryParameterValue>();
        allQueryParameters.putAll(query.encodedQueryParameters());
        allQueryParameters.putAll(explicitQueryParameters);
        String pathWithoutEncodedQueryParameters = query.path();
        HashMap<HeaderKey, HeaderValue> fixedHeaders = new HashMap<HeaderKey, HeaderValue>(headers);
        body.contentType().ifPresent(contentType -> fixedHeaders.put(HeaderKey.headerKey("Content-Type"), HeaderValue.headerValue(contentType)));
        InputStream bodyStream = body.inputStream();
        return new HttpClientRequest<T>(pathWithoutEncodedQueryParameters, method, fixedHeaders, allQueryParameters, bodyStream, targetType);
    }

    public String path() {
        return this.path;
    }

    public String method() {
        return this.method;
    }

    public Map<String, String> headers() {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        this.headers.forEach((key, value) -> stringMap.put(key.value(), value.value()));
        return stringMap;
    }

    public Map<String, String> queryParameters() {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        this.queryParameters.forEach((key, value) -> stringMap.put(key.value(), value.value()));
        return stringMap;
    }

    public InputStream body() {
        return this.body;
    }

    Class<T> targetType() {
        return this.targetType;
    }

    private HttpClientRequest(String path, String method, Map<HeaderKey, HeaderValue> headers, Map<QueryParameterKey, QueryParameterValue> queryParameters, InputStream body, Class<T> targetType) {
        this.path = path;
        this.method = method;
        this.headers = headers;
        this.queryParameters = queryParameters;
        this.body = body;
        this.targetType = targetType;
    }
}

