/*
 * Decompiled with CFR 0.152.
 */
package com.envimate.httpmate.client.issuer.real;

import com.envimate.httpmate.client.BasePath;
import com.envimate.httpmate.client.issuer.real.Protocol;
import com.envimate.httpmate.util.Validators;
import java.util.Map;
import java.util.StringJoiner;

final class Endpoint {
    private final Protocol protocol;
    private final String host;
    private final int port;
    private final BasePath basePath;

    static Endpoint endpoint(Protocol protocol, String host, int port, BasePath basePath) {
        Validators.validateNotNull((Object)((Object)protocol), (String)"protocol");
        Validators.validateNotNull((Object)host, (String)"host");
        Validators.validateNotNull((Object)port, (String)"port");
        Validators.validateNotNull((Object)basePath, (String)"basePath");
        return new Endpoint(protocol, host, port, basePath);
    }

    String host() {
        return this.host;
    }

    int port() {
        return this.port;
    }

    Protocol protocol() {
        return this.protocol;
    }

    String toUrl(String path, Map<String, String> queryParameters) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.protocol.identifier());
        urlBuilder.append("://");
        urlBuilder.append(this.host);
        urlBuilder.append(":");
        urlBuilder.append(this.port);
        String fixedPath = this.basePath.concatenateWithStartingAndTrailingSlash(path);
        urlBuilder.append(fixedPath);
        String queryParametersString = Endpoint.createQuery(queryParameters);
        urlBuilder.append(queryParametersString);
        return urlBuilder.toString();
    }

    private static String createQuery(Map<String, String> queryParameters) {
        if (queryParameters.isEmpty()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner("&", "?", "");
        queryParameters.forEach((key, value) -> joiner.add(key + "=" + value));
        return joiner.toString();
    }

    public String toString() {
        return "Endpoint(protocol=" + this.protocol + ", host=" + this.host + ", port=" + this.port + ", basePath=" + this.basePath + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)o;
        Protocol this$protocol = this.protocol;
        Protocol other$protocol = other.protocol;
        if (this$protocol == null ? other$protocol != null : !((Object)((Object)this$protocol)).equals((Object)other$protocol)) {
            return false;
        }
        String this$host = this.host;
        String other$host = other.host;
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        BasePath this$basePath = this.basePath;
        BasePath other$basePath = other.basePath;
        return !(this$basePath == null ? other$basePath != null : !((Object)this$basePath).equals(other$basePath));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Protocol $protocol = this.protocol;
        result = result * 59 + ($protocol == null ? 43 : ((Object)((Object)$protocol)).hashCode());
        String $host = this.host;
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.port;
        BasePath $basePath = this.basePath;
        result = result * 59 + ($basePath == null ? 43 : ((Object)$basePath).hashCode());
        return result;
    }

    private Endpoint(Protocol protocol, String host, int port, BasePath basePath) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.basePath = basePath;
    }
}

