/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.image;

import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.image.ImageAnimation;
import java.awt.image.RenderedImage;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class PauseFrameImageAnimation
implements ImageAnimation {
    private ImageAnimation source;
    private Integer frameIndex;
    private Integer numFrames;

    public PauseFrameImageAnimation(Builder builder) {
        this.source = builder.source;
        this.frameIndex = builder.frameIndex;
        this.numFrames = builder.numFrames;
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardNotNull(this.source, "source cannot be null");
        ValidationUtils.guardNotNull(this.frameIndex, "frameIndex cannot be null");
        ValidationUtils.guardNotNegativeInt(this.numFrames, "numFrames cannot be negative");
    }

    @Override
    public int getFrameWidth() {
        return this.source.getFrameWidth();
    }

    @Override
    public int getFrameHeight() {
        return this.source.getFrameHeight();
    }

    @Override
    public int getNumFrames() {
        return this.numFrames;
    }

    @Override
    public int getFrameDuration() {
        return this.source.getFrameDuration();
    }

    @Override
    public RenderedImage getFrame(int index) {
        return this.source.getFrame(this.frameIndex);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static PauseFrameImageAnimation create(ImageAnimation source, int frameIndex, int numFrames) {
        return new Builder().setSource(source).setFrameIndex(frameIndex).setNumFrames(numFrames).build();
    }

    public static class Builder {
        private ImageAnimation source;
        private Integer frameIndex;
        private Integer numFrames;

        public Builder setSource(ImageAnimation source) {
            this.source = source;
            return this;
        }

        public Builder setFrameIndex(Integer frameIndex) {
            this.frameIndex = frameIndex;
            return this;
        }

        public Builder setNumFrames(Integer numFrames) {
            this.numFrames = numFrames;
            return this;
        }

        public PauseFrameImageAnimation build() {
            return new PauseFrameImageAnimation(this);
        }
    }
}

