/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.engine;

import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.engine.TaskRunExceptionReport;
import com.enterprisemath.utils.engine.TaskRunListener;
import com.enterprisemath.utils.engine.TaskRunStopReport;
import com.enterprisemath.utils.engine.TaskRunSuccessReport;
import com.enterprisemath.utils.messaging.SystemMessenger;
import org.apache.commons.lang.builder.ToStringBuilder;

public class MessageExceptionTaskRunListener
implements TaskRunListener {
    private SystemMessenger messenger;

    public MessageExceptionTaskRunListener(Builder builder) {
        this.messenger = builder.messenger;
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardNotNull(this.messenger, "messenger cannot be null");
    }

    @Override
    public void runFinishedBySuccess(TaskRunSuccessReport report) {
    }

    @Override
    public void runFinishedByExceptin(TaskRunExceptionReport report) {
        this.messenger.sendError("Error during task " + report.getCode(), "Exception has been thrown during invoking " + report.getTaskClass() + " with " + report.getParameters(), report.getExceptionDetails());
    }

    @Override
    public void runFinishedByStop(TaskRunStopReport report) {
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class Builder {
        private SystemMessenger messenger;

        public Builder setMessenger(SystemMessenger messenger) {
            this.messenger = messenger;
            return this;
        }

        public MessageExceptionTaskRunListener build() {
            return new MessageExceptionTaskRunListener(this);
        }
    }
}

