/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.engine;

import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.engine.TaskServiceProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class MapTaskServiceProvider
implements TaskServiceProvider {
    private Map<String, Object> services;

    public MapTaskServiceProvider(Builder builder) {
        this.services = DomainUtils.softCopyUnmodifiableMap(builder.services);
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardNotEmptyNullMap(this.services, "services cannot have empty key or null value");
    }

    @Override
    public <T> T getService(String name, Class<T> clazz) {
        return (T)this.services.get(name);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class Builder {
        private Map<String, Object> services = new HashMap<String, Object>();

        public Builder setServices(Map<String, Object> services) {
            this.services = DomainUtils.softCopyMap(services);
            return this;
        }

        public Builder addService(String name, Object service) {
            this.services.put(name, service);
            return this;
        }

        public MapTaskServiceProvider build() {
            return new MapTaskServiceProvider(this);
        }
    }
}

