/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.engine;

import com.enterprisemath.utils.DatesProvider;
import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.UniqueCodeGenerator;
import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.engine.Engine;
import com.enterprisemath.utils.engine.EngineStatus;
import com.enterprisemath.utils.engine.EngineTaskStatus;
import com.enterprisemath.utils.engine.Task;
import com.enterprisemath.utils.engine.TaskManager;
import com.enterprisemath.utils.engine.TaskRunExceptionReport;
import com.enterprisemath.utils.engine.TaskRunListener;
import com.enterprisemath.utils.engine.TaskRunOrder;
import com.enterprisemath.utils.engine.TaskRunStopReport;
import com.enterprisemath.utils.engine.TaskRunSuccessReport;
import com.enterprisemath.utils.engine.TaskServiceProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ExecutorServiceEngine
implements Engine {
    private ExecutorService executor;
    private TaskServiceProvider serviceProvider;
    private TaskRunListener listener;
    private UniqueCodeGenerator uniqueCodeGenerator;
    private DatesProvider datesProvider;
    private List<TaskHandler> handlers = new ArrayList<TaskHandler>();
    private final Object lock = new Object();

    public ExecutorServiceEngine(Builder builder) {
        this.executor = builder.executor;
        this.serviceProvider = builder.serviceProvider;
        this.listener = builder.listener;
        this.uniqueCodeGenerator = builder.uniqueCodeGenerator;
        this.datesProvider = builder.datesProvider;
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardNotNull(this.executor, "executor cannot be null");
        ValidationUtils.guardNotNull(this.serviceProvider, "serviceProvider cannot be null");
        ValidationUtils.guardNotNull(this.listener, "listener cannot be null");
        ValidationUtils.guardNotNull(this.uniqueCodeGenerator, "uniqueCodeGenerator cannot be null");
        ValidationUtils.guardNotNull(this.datesProvider, "datesProvider cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EngineStatus getStatus() {
        Object object = this.lock;
        synchronized (object) {
            this.cleanHandlers();
            EngineStatus.Builder res = new EngineStatus.Builder();
            for (TaskHandler hdl : this.handlers) {
                EngineTaskStatus ets = new EngineTaskStatus.Builder().setCode(hdl.getCode()).setTaskClass(hdl.task.getClass().getName()).setProgress(hdl.task.getProgress()).setStartTimestamp(hdl.startTimestamp).build();
                res.addTaskStatus(ets);
            }
            return res.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskManager getTaskManager(String code) {
        Object object = this.lock;
        synchronized (object) {
            this.cleanHandlers();
            for (TaskHandler hdl : this.handlers) {
                if (!hdl.getCode().equals(code)) continue;
                return hdl;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskManager run(TaskRunOrder order) {
        Object object = this.lock;
        synchronized (object) {
            TaskHandler handler = new TaskHandler(this, order);
            Future<Map<String, String>> f = this.executor.submit(handler);
            handler.future = f;
            this.cleanHandlers();
            this.handlers.add(handler);
            return handler;
        }
    }

    private void cleanHandlers() {
        ArrayList<TaskHandler> hdls = new ArrayList<TaskHandler>();
        for (TaskHandler th : this.handlers) {
            if (th.isDone()) continue;
            hdls.add(th);
        }
        this.handlers = hdls;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private static class TaskHandler
    implements TaskManager,
    Callable<Map<String, String>> {
        private ExecutorServiceEngine parent;
        private Map<String, String> parameters;
        private String code;
        private Date startTimestamp;
        private Task task;
        private Future<Map<String, String>> future = null;
        private State state = State.RUNNING;
        private Map<String, String> exceptionDetails = null;
        private Map<String, String> result = null;
        private final Object lock = new Object();

        public TaskHandler(ExecutorServiceEngine parent, TaskRunOrder order) {
            this.parent = parent;
            this.parameters = DomainUtils.softCopyUnmodifiableMap(order.getParameters());
            ValidationUtils.guardNotNull(parent, "parent cannot be null");
            ValidationUtils.guardNotEmptyNullMap(this.parameters, "parameters cannot have empty key or null value");
            this.code = parent.uniqueCodeGenerator.generateUniqueCode("TASK");
            this.startTimestamp = parent.datesProvider.now();
            this.task = order.createTaskInstance();
        }

        @Override
        public String getCode() {
            return this.code;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            Object object = this.lock;
            synchronized (object) {
                return !this.state.equals((Object)State.RUNNING);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, String> getResult() {
            Object object = this.lock;
            synchronized (object) {
                if (this.state.equals((Object)State.COMLPETED)) {
                    return DomainUtils.softCopyMap(this.result);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, String> getExceptionDetails() {
            Object object = this.lock;
            synchronized (object) {
                if (this.state.equals((Object)State.EXCEPTION)) {
                    return DomainUtils.softCopyMap(this.exceptionDetails);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            Object object = this.lock;
            synchronized (object) {
                if (this.state.equals((Object)State.RUNNING)) {
                    this.state = State.STOPPED;
                    this.future.cancel(true);
                    this.parent.listener.runFinishedByStop(new TaskRunStopReport.Builder().setCode(this.code).setTaskClass(this.task.getClass().getName()).setParameters(this.parameters).setStartTimestamp(this.startTimestamp).setEndTimestamp(this.parent.datesProvider.now()).build());
                }
            }
        }

        @Override
        public void waitTillDone() {
            try {
                this.future.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, String> call() throws Exception {
            try {
                Map<String, String> res = this.task.run(this.parent.serviceProvider, this.parameters);
                Object object = this.lock;
                synchronized (object) {
                    if (this.state.equals((Object)State.RUNNING)) {
                        this.result = DomainUtils.softCopyMap(res);
                        this.state = State.COMLPETED;
                        this.parent.listener.runFinishedBySuccess(new TaskRunSuccessReport.Builder().setCode(this.code).setTaskClass(this.task.getClass().getName()).setParameters(this.parameters).setResult(this.result).setStartTimestamp(this.startTimestamp).setEndTimestamp(this.parent.datesProvider.now()).build());
                    }
                }
            }
            catch (Throwable t) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.state.equals((Object)State.RUNNING)) {
                        this.exceptionDetails = new HashMap<String, String>();
                        this.exceptionDetails.put("class", t.getClass().getName());
                        this.exceptionDetails.put("message", StringUtils.defaultString((String)t.getMessage()));
                        this.exceptionDetails.put("stackTrace", ExceptionUtils.getStackTrace((Throwable)t));
                        this.state = State.EXCEPTION;
                        this.parent.listener.runFinishedByExceptin(new TaskRunExceptionReport.Builder().setCode(this.code).setTaskClass(this.task.getClass().getName()).setParameters(this.parameters).setExceptionDetails(this.exceptionDetails).setStartTimestamp(this.startTimestamp).setEndTimestamp(this.parent.datesProvider.now()).build());
                    }
                }
            }
            return null;
        }

        private static enum State {
            RUNNING,
            COMLPETED,
            EXCEPTION,
            STOPPED;

        }
    }

    public static class Builder {
        private ExecutorService executor;
        private TaskServiceProvider serviceProvider;
        private TaskRunListener listener;
        private UniqueCodeGenerator uniqueCodeGenerator;
        private DatesProvider datesProvider;

        public Builder setExecutor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder setServiceProvider(TaskServiceProvider serviceProvider) {
            this.serviceProvider = serviceProvider;
            return this;
        }

        public Builder setListener(TaskRunListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder setUniqueCodeGenerator(UniqueCodeGenerator uniqueCodeGenerator) {
            this.uniqueCodeGenerator = uniqueCodeGenerator;
            return this;
        }

        public Builder setDatesProvider(DatesProvider datesProvider) {
            this.datesProvider = datesProvider;
            return this;
        }

        public ExecutorServiceEngine build() {
            return new ExecutorServiceEngine(this);
        }
    }
}

