/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.cache;

import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.cache.ObjectCache;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class InMemoryObjectCache
implements ObjectCache {
    private Map<String, Object> buffer;
    private final Object lock = new Object();

    public InMemoryObjectCache(Builder builder) {
        this.guardInvariants();
        this.buffer = new HashMap<String, Object>();
    }

    private void guardInvariants() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.buffer.put(key, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        Object object = this.lock;
        synchronized (object) {
            this.buffer.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.buffer.containsKey(key)) {
                throw new NoSuchElementException("element doesn't exists: key = " + key);
            }
            return this.buffer.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key, Object def) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.buffer.containsKey(key)) {
                return def;
            }
            return this.buffer.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getKeys() {
        Object object = this.lock;
        synchronized (object) {
            return DomainUtils.softCopySet(this.buffer.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.buffer = new HashMap<String, Object>();
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static InMemoryObjectCache create() {
        return new Builder().build();
    }

    public static class Builder {
        public InMemoryObjectCache build() {
            return new InMemoryObjectCache(this);
        }
    }
}

