/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.cache;

import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.cache.ObjectCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ExpiringInMemoryObjectCache
implements ObjectCache {
    private int expireTimeout;
    private Boolean renewOnGet;
    private Map<String, List<Object>> buffer;
    private final Object lock = new Object();

    public ExpiringInMemoryObjectCache(Builder builder) {
        this.expireTimeout = builder.expireTimeout;
        this.renewOnGet = builder.renewOnGet;
        this.guardInvariants();
        this.buffer = new HashMap<String, List<Object>>();
    }

    private void guardInvariants() {
        ValidationUtils.guardPositiveInt(this.expireTimeout, "expireTimeout must be positive");
        ValidationUtils.guardNotNull(this.renewOnGet, "renewOnGet cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.expireOld();
            Long et = System.currentTimeMillis() + (long)this.expireTimeout;
            ArrayList<Object> pair = new ArrayList<Object>(2);
            pair.add(et);
            pair.add(object);
            this.buffer.put(key, pair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        Object object = this.lock;
        synchronized (object) {
            this.expireOld();
            this.buffer.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key) {
        Object object = this.lock;
        synchronized (object) {
            this.expireOld();
            if (!this.buffer.containsKey(key)) {
                throw new NoSuchElementException("element doesn't exists: key = " + key);
            }
            List<Object> pair = this.buffer.get(key);
            if (this.renewOnGet.booleanValue()) {
                Long et = System.currentTimeMillis() + (long)this.expireTimeout;
                pair.set(0, et);
            }
            return pair.get(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key, Object def) {
        Object object = this.lock;
        synchronized (object) {
            this.expireOld();
            if (!this.buffer.containsKey(key)) {
                return def;
            }
            List<Object> pair = this.buffer.get(key);
            if (this.renewOnGet.booleanValue()) {
                Long et = System.currentTimeMillis() + (long)this.expireTimeout;
                pair.set(0, et);
            }
            return pair.get(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getKeys() {
        Object object = this.lock;
        synchronized (object) {
            this.expireOld();
            return DomainUtils.softCopySet(this.buffer.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.buffer = new HashMap<String, List<Object>>();
        }
    }

    private void expireOld() {
        long ct = System.currentTimeMillis();
        HashSet<String> remove = new HashSet<String>();
        for (String key : this.buffer.keySet()) {
            List<Object> pair = this.buffer.get(key);
            if ((Long)pair.get(0) >= ct) continue;
            remove.add(key);
        }
        for (String key : remove) {
            this.buffer.remove(key);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static ExpiringInMemoryObjectCache create(int expireTimeout, boolean renewOnGet) {
        return new Builder().setExpireTimeout(expireTimeout).setRenewOnGet(renewOnGet).build();
    }

    public static class Builder {
        private int expireTimeout = 0;
        private Boolean renewOnGet = null;

        public Builder setExpireTimeout(int expireTimeout) {
            this.expireTimeout = expireTimeout;
            return this;
        }

        public Builder setRenewOnGet(Boolean renewOnGet) {
            this.renewOnGet = renewOnGet;
            return this;
        }

        public ExpiringInMemoryObjectCache build() {
            return new ExpiringInMemoryObjectCache(this);
        }
    }
}

