/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class ValidationUtils {
    private ValidationUtils() {
    }

    public static void guardTrue(boolean obj, String msg) {
        if (!obj) {
            throw new IllegalArgumentException("guardTrue failed: " + msg);
        }
    }

    public static void guardFalse(boolean obj, String msg) {
        if (obj) {
            throw new IllegalArgumentException("guardFalse failed: " + msg);
        }
    }

    public static void guardNull(Object obj, String msg) {
        if (obj != null) {
            throw new IllegalArgumentException("guardNull failed for " + obj + ": " + msg);
        }
    }

    public static void guardNotNull(Object obj, String msg) {
        if (obj == null) {
            throw new IllegalArgumentException("guardNotNull failed: " + msg);
        }
    }

    public static void guardEmpty(String str, String msg) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            throw new IllegalArgumentException("guardEmpty failed for " + str + ": " + msg);
        }
    }

    public static void guardNotEmpty(String str, String msg) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            throw new IllegalArgumentException("guardNotEmpty failed: " + msg);
        }
    }

    public static void guardMatch(String str, String regex, String msg) {
        if (str == null) {
            throw new NullPointerException("guardMatch failed for null string with " + regex + ": " + msg);
        }
        if (!str.matches(regex)) {
            throw new IllegalArgumentException("guardMatch failed for " + str + " with " + regex + ": " + msg);
        }
    }

    public static <T> void guardNotNullCollection(Collection<T> collection, String msg) {
        if (collection == null) {
            throw new IllegalArgumentException("guardNotNullCollection failed for null: " + msg);
        }
        for (T elm : collection) {
            if (elm != null) continue;
            throw new IllegalArgumentException("guardNotNullCollection failed for " + collection + ": " + msg);
        }
    }

    public static void guardNotEmptyStringInCollection(Collection<String> collection, String msg) {
        if (collection == null) {
            throw new IllegalArgumentException("guardNotEmptyStringInCollection failed for null: " + msg);
        }
        for (String elm : collection) {
            if (!StringUtils.isEmpty((CharSequence)elm)) continue;
            throw new IllegalArgumentException("guardNotEmptyStringInCollection failed for " + collection + ": " + msg);
        }
    }

    public static <K, V> void guardNotNullMap(Map<K, V> map, String msg) {
        if (map == null) {
            throw new IllegalArgumentException("guardNotNullMap failed for null: " + msg);
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalArgumentException("guardNotNullMap failed for " + map + ": " + msg);
            }
            if (entry.getValue() != null) continue;
            throw new IllegalArgumentException("guardNotNullMap failed for " + map + ": " + msg);
        }
    }

    public static <V> void guardNotEmptyNullMap(Map<String, V> map, String msg) {
        if (map == null) {
            throw new IllegalArgumentException("guardNotEmptyNullMap failed for null: " + msg);
        }
        for (Map.Entry<String, V> entry : map.entrySet()) {
            if (StringUtils.isEmpty((CharSequence)entry.getKey())) {
                throw new IllegalArgumentException("guardNotEmptyNullMap failed for " + map + ": " + msg);
            }
            if (entry.getValue() != null) continue;
            throw new IllegalArgumentException("guardNotEmptyNullMap failed for " + map + ": " + msg);
        }
    }

    public static void guardNotNegativeInt(int number, String msg) {
        if (number < 0) {
            throw new IllegalArgumentException("guardNotNegativeInt failed for " + number + ": " + msg);
        }
    }

    public static void guardPositiveInt(int number, String msg) {
        if (number < 1) {
            throw new IllegalArgumentException("guardPositiveInt failed for " + number + ": " + msg);
        }
    }

    public static void guardPositiveLong(long number, String msg) {
        if (number < 1L) {
            throw new IllegalArgumentException("guardPositiveLong failed for " + number + ": " + msg);
        }
    }

    public static void guardNotZeroLong(long obj, String msg) {
        if (obj == 0L) {
            throw new IllegalArgumentException("guardNotZeroLong failed for " + obj + ": " + msg);
        }
    }

    public static void guardNotZeroInt(int obj, String msg) {
        if (obj == 0) {
            throw new IllegalArgumentException("guardNotZeroInt failed for " + obj + ": " + msg);
        }
    }

    public static void guardPositiveDouble(double number, String msg) {
        if (number > 0.0) {
            return;
        }
        throw new IllegalArgumentException("guardPositiveDouble failed for " + number + ": " + msg);
    }

    public static void guardBoundedDouble(double number, String msg) {
        if (Double.isNaN(number)) {
            throw new IllegalArgumentException("guardBoundedDouble failed for " + number + ": " + msg);
        }
        if (Double.isInfinite(number)) {
            throw new IllegalArgumentException("guardBoundedDouble failed for " + number + ": " + msg);
        }
    }

    public static void guardClosedIntervalDouble(double number, double min, double max, String msg) {
        if (number < min || number > max || Double.isNaN(number)) {
            throw new IllegalArgumentException("guardClosedIntervalDouble failed for " + number + " and [" + min + ", " + max + "]: " + msg);
        }
    }

    public static void guardNotNegativeLong(long number, String msg) {
        if (number < 0L) {
            throw new IllegalArgumentException("guardNotNegativeLong failed for " + number + ": " + msg);
        }
    }

    public static void guardNotNegativeDouble(double number, String msg) {
        if (number >= 0.0) {
            return;
        }
        throw new IllegalArgumentException("guardNotNegativeDouble failed for " + number + ": " + msg);
    }

    public static void guardIpString(String ip, String msg) {
        if (!(ip = StringUtils.defaultString((String)ip)).matches("[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}")) {
            throw new IllegalArgumentException("guardIpString failed for " + ip + ": " + msg);
        }
    }

    public static void guardEquals(Object obj1, Object obj2, String msg) {
        if (obj1 == obj2) {
            return;
        }
        if (obj1 == null || !obj1.equals(obj2)) {
            throw new IllegalArgumentException("guardEquals failed for " + obj1 + " and " + obj2 + ": " + msg);
        }
    }

    public static void guardGreaterDouble(double number1, double number2, String msg) {
        if (number1 > number2) {
            return;
        }
        throw new IllegalArgumentException("guardGreaterDouble failed for " + number1 + " and " + number2 + ": " + msg);
    }

    public static void guardGreaterOrEqualInt(int number1, int number2, String msg) {
        if (number2 > number1) {
            throw new IllegalArgumentException("guardGreaterOrEqualInt failed for " + number1 + " and " + number2 + ": " + msg);
        }
    }

    public static void guardGreaterOrEqualLong(long number1, long number2, String msg) {
        if (number2 > number1) {
            throw new IllegalArgumentException("guardGreaterOrEqualLong failed for " + number1 + " and " + number2 + ": " + msg);
        }
    }

    public static void guardGreaterOrEqualDouble(double number1, double number2, String msg) {
        if (number1 >= number2) {
            return;
        }
        throw new IllegalArgumentException("guardGreaterOrEqualDouble failed for " + number1 + " and " + number2 + ": " + msg);
    }

    public static void guardInstanceOf(Object obj, Class<?> clazz, String msg) {
        if (clazz == null) {
            throw new IllegalArgumentException("guardInstanceOf null failed for " + obj + ": " + msg);
        }
        if (obj == null) {
            throw new IllegalArgumentException("guardInstanceOf " + clazz.getName() + " failed for null: " + msg);
        }
        if (!clazz.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("guardInstanceOf " + clazz.getName() + " failed for " + obj + ": " + msg);
        }
    }

    public static void guardIn(Object obj, Collection<?> allowed, String msg) {
        if (!allowed.contains(obj)) {
            throw new IllegalArgumentException("guardIn failed for " + obj + " in " + allowed + ": " + msg);
        }
    }

    public static void guardTruncatedDate(Date date, String msg) {
        Date truncated = DateUtils.truncate((Date)date, (int)5);
        if (date.getTime() != truncated.getTime()) {
            throw new IllegalArgumentException("guardTruncatedDate failed for " + date + ": " + msg);
        }
    }

    public static void guardGetterExistsForEnum(Class<?> clazz, Enum<?> enm, String msg) {
        if (clazz == null) {
            throw new IllegalArgumentException("guardGetterExistsForEnum failed for null and " + enm + ": " + msg);
        }
        if (enm == null) {
            throw new IllegalArgumentException("guardGetterExistsForEnum failed for " + clazz + " and null: " + msg);
        }
        String name = enm.name().toLowerCase();
        String getterBase = "";
        boolean capital = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                capital = true;
                continue;
            }
            if (capital) {
                getterBase = getterBase + String.valueOf(c).toUpperCase();
                capital = false;
                continue;
            }
            getterBase = getterBase + String.valueOf(c);
        }
        try {
            clazz.getMethod("get" + getterBase, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                clazz.getMethod("is" + getterBase, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                throw new IllegalArgumentException("guardGetterExistsForEnum failed for " + clazz + " and " + enm + ": " + msg);
            }
            catch (SecurityException e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

