/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils;

import com.enterprisemath.utils.ValidationUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class StringParser {
    private String input;
    private int cursor = 0;

    public StringParser(String input) {
        this.input = input;
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardNotNull(this.input, "input cannot be null");
    }

    public boolean hasNext() {
        return this.cursor < this.input.length();
    }

    public String readCharacter() {
        char res = this.input.charAt(this.cursor);
        ++this.cursor;
        return String.valueOf(res);
    }

    public String readCharacter(String defaultEnd) {
        if (this.cursor >= this.input.length()) {
            return defaultEnd;
        }
        char res = this.input.charAt(this.cursor);
        ++this.cursor;
        return String.valueOf(res);
    }

    public String lookupCharacter() {
        char res = this.input.charAt(this.cursor);
        return String.valueOf(res);
    }

    public String lookupCharacter(String defaultEnd) {
        if (this.cursor >= this.input.length()) {
            return defaultEnd;
        }
        char res = this.input.charAt(this.cursor);
        return String.valueOf(res);
    }

    public String readTillStop(String stopCharacters) {
        String c;
        StringBuilder res = new StringBuilder();
        while (this.cursor < this.input.length() && !stopCharacters.contains(c = this.input.substring(this.cursor, this.cursor + 1))) {
            ++this.cursor;
            res.append(c);
        }
        return res.toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

