/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils;

import com.enterprisemath.utils.ValidationUtils;
import java.util.Comparator;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class PropertyStringComparator
implements Comparator<String> {
    private PropertyStringComparator() {
    }

    @Override
    public int compare(String o1, String o2) {
        ValidationUtils.guardNotNull(o1, "o1 is null which is not supported");
        ValidationUtils.guardNotNull(o2, "o2 is null which is not supported");
        if (o1.equals(o2)) {
            return 0;
        }
        String[] parts1 = o1.split("\\.");
        String[] parts2 = o2.split("\\.");
        int max = Math.min(parts1.length, parts2.length);
        for (int i = 0; i < max; ++i) {
            String part1 = parts1[i];
            String part2 = parts2[i];
            if (part1.equals(part2)) continue;
            if (part1.matches("^.+\\[[0-9]+\\]$") && part2.matches("^.+\\[[0-9]+\\]$")) {
                String[] pp2;
                String[] pp1 = part1.split("[\\[\\]]", 3);
                if (pp1[0].equals((pp2 = part2.split("[\\[\\]]", 3))[0])) {
                    int index2;
                    int index1 = Integer.valueOf(pp1[1]);
                    if (index1 == (index2 = Integer.valueOf(pp2[1]).intValue())) continue;
                    return index1 < index2 ? -1 : 1;
                }
                return pp1[0].compareTo(pp2[0]) < 0 ? -1 : 1;
            }
            return part1.compareTo(part2) < 0 ? -1 : 1;
        }
        return parts1.length < parts2.length ? -1 : 1;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static PropertyStringComparator create() {
        return new PropertyStringComparator();
    }
}

