/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils;

import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.PropertyStringComparator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONUtils {
    private JSONUtils() {
    }

    public static String encodeStringMap(Map<String, String> data) {
        TreeMap<String, String> sorted = new TreeMap<String, String>(PropertyStringComparator.create());
        sorted.putAll(data);
        ArrayList<JSONObject> items = new ArrayList<JSONObject>();
        for (String key : sorted.keySet()) {
            JSONObject item = new JSONObject();
            item.put("key", (Object)key);
            item.put("value", sorted.get(key));
            items.add(item);
        }
        JSONArray array = new JSONArray(items);
        return array.toString();
    }

    public static String encodeSimpleStringMap(Map<String, String> data) {
        SortedMap<String, String> sorted = DomainUtils.softCopySortedMap(data);
        JSONObject map = new JSONObject(sorted);
        return map.toString();
    }

    public static Map<String, String> decodeStringMap(String data) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (data.startsWith("[")) {
            JSONArray array = new JSONArray(data);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject item = (JSONObject)array.get(i);
                String key = item.getString("key");
                String value = item.getString("value");
                res.put(key, value);
            }
        } else if (data.startsWith("{")) {
            JSONObject obj = new JSONObject(data);
            for (String key : obj.keySet()) {
                res.put(key, obj.getString(key));
            }
        } else {
            throw new IllegalArgumentException("data string must start with '[' or '{'" + StringUtils.substring((String)data, (int)0, (int)4) + "...");
        }
        return res;
    }

    public static String encodeStringList(List<String> data) {
        JSONArray res = new JSONArray();
        for (String elm : data) {
            res.put((Object)elm);
        }
        return res.toString();
    }

    public static List<String> decodeStringList(String data) {
        ArrayList<String> res = new ArrayList<String>();
        JSONArray array = new JSONArray(data);
        for (int i = 0; i < array.length(); ++i) {
            String item = (String)array.get(i);
            res.add(item);
        }
        return res;
    }
}

