package com.enterprisemath.utils.messaging;

/**
 * Enumerates the security ways during message transport.
 * 
 * @author radek.hecl
 *
 */
public enum TransportSecurity {
    
    /**
     * None security is required. This is allowed only for development purposes.
     * No body can use this in production.
     */
    NONE,
    
    /**
     * Security is done by SSL protocol.
     */
    SSL,
    
    /**
     * Security is done by TLS protocol.
     */
    TLS
}
