package com.enterprisemath.utils.image;

import java.awt.image.RenderedImage;

/**
 * Defines required functionality for the animation
 *
 * @author radek.hecl
 *
 */
public interface ImageAnimation {

    /**
     * Returns frame width. Implementation is responsible to keep all the frames with this width.
     *
     * @return frame width
     */
    public int getFrameWidth();

    /**
     * Returns frame height. Implementation is responsible to keep all the frames with this height.
     *
     * @return frame height
     */
    public int getFrameHeight();

    /**
     * Returns total number of frames.
     *
     * @return total number of frames
     */
    public int getNumFrames();

    /**
     * Returns duration of one frame in milliseconds.
     *
     * @return duration of one frame in milliseconds
     */
    public int getFrameDuration();

    /**
     * Returns the frame on the the specified index.
     * It is responsibility of the implementation to return frame with the frameWidth and frameHeight.
     *
     * @param index index of the frame, must be in interval [0, numFrames - 1]
     * @return image frame
     */
    public RenderedImage getFrame(int index);

}
