package com.enterprisemath.utils.engine;

/**
 * Defines functionality of the run result.
 *
 * @author radek.hecl
 */
public interface TaskRunListener {

    /**
     * Called when run finished by successful return.
     *
     * @param report report
     */
    public void runFinishedBySuccess(TaskRunSuccessReport report);

    /**
     * Called when run finished by exception.
     *
     * @param report report
     */
    public void runFinishedByExceptin(TaskRunExceptionReport report);

    /**
     * Called when run finished by calling the stop method.
     *
     * @param report report
     */
    public void runFinishedByStop(TaskRunStopReport report);

}
