package com.enterprisemath.utils.engine;

import java.util.Map;

/**
 * Defines the interface for engine task.
 *
 * @author radek.hecl
 *
 */
public interface Task {

    /**
     * Returns current progress.
     *
     * @return current progress
     */
    public TaskProgress getProgress();

    /**
     * Runs the task.
     *
     * @param serviceProvider provider for services
     * @param parameters input parameters
     * @return output parameters
     */
    public Map<String, String> run(TaskServiceProvider serviceProvider, Map<String, String> parameters);

}
