package com.enterprisemath.utils.cache;

import java.util.NoSuchElementException;
import java.util.Set;

/**
 * Defines interface for caching objects.
 * <p>
 * <strong>Note:</strong> Adding functions to this interface will <strong>NOT</strong> be
 * considered as breaking binary compatibility.
 * </p>
 *
 * @author radek.hecl
 */
public interface ObjectCache {

    /**
     * Puts object into cache. If object with the same key exists, then it is are overridden.
     *
     * @param key data key
     * @param object object
     */
    public void put(String key, Object object);

    /**
     * Removes the specified key.
     *
     * @param key key
     */
    public void remove(String key);

    /**
     * Retrieves object.
     *
     * @param key data key
     * @return object
     * @throws NoSuchElementException if key doesn't exists
     */
    public Object get(String key);

    /**
     * Returns object in the non strict manner. Default value is
     * returned if key doesn't exists.
     *
     * @param key key
     * @param def default value returned if key doesn't exists
     * @return object or default value
     */
    public Object get(String key, Object def);

    /**
     * Returns all keys which are in use.
     *
     * @return all keys which are in use
     */
    public Set<String> getKeys();

    /**
     * Clears the cache, all objects are removed.
     */
    public void clear();

}
