/**
*
*  edtFTPj
*
*  Copyright (C) 2000  Enterprise Distributed Technologies Ltd
*
*  www.enterprisedt.com
*
*  This library is free software; you can redistribute it and/or
*  modify it under the terms of the GNU Lesser General Public
*  License as published by the Free Software Foundation; either
*  version 2.1 of the License, or (at your option) any later version.
*
*  This library is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  Lesser General Public License for more details.
*
*  You should have received a copy of the GNU Lesser General Public
*  License along with this library; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
*  Bug fixes, suggestions and comments should be should posted on 
*  http://www.enterprisedt.com/forums/index.php
*
*  Change Log:
*
*        $Log: TestTools.java,v $
*        Revision 1.3  2006/02/16 19:49:14  hans
*        Fixed comments.
*
*        Revision 1.2  2005/10/15 22:45:36  bruceb
*        added getters
*
*        Revision 1.1  2005/07/15 14:41:12  bruceb
*        needed for rework of unit testing structure
*
*/

package com.enterprisedt.net.ftp.test;

import java.util.Properties;

import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.util.debug.Logger;

/**
*  Base class for login tools
*
*  @author         Bruce Blackshaw
*  @version        $Revision: 1.3 $
*/
abstract public class TestTools {
    
    /**
     *  Log stream
     */
    protected Logger log = Logger.getLogger(TestTools.class);
    
    /**
     * Test properties
     */
    protected Properties props;
    
    /**
     *  Test user
     */
    protected String user;

    /**
     *  User password
     */
    protected String password;

    /**
     *  Remote test host
     */
    protected String host;

    /**
     *  Socket timeout
     */
    protected int timeout;
        
    /**
     * Constructor
     */
    public TestTools() {}
    
    /**
     * Get password
     * 
     * @return Password
     */    
    public String getPassword() {
        return password;
    }

    /**
     * Get username 
     * 
     * @return User
     */
    public String getUser() {
        return user;
    }
    
    /**
     * Get host 
     * 
     * @return Host
     */
    public String getHost() {
        return host;
    }  


    /**
     * Set test properties for connecting
     * 
     * @param props     properties obj
     */
    public void setProperties(Properties props) {
        this.props = props;    
        
        user = props.getProperty("ftptest.user");
        password = props.getProperty("ftptest.password");
        
        host = props.getProperty("ftptest.host");
        
        // socket timeout
        String timeoutStr = props.getProperty("ftptest.timeout");
        this.timeout = Integer.parseInt(timeoutStr);
    }
    
    /**
     * Connect to the remote host
     * 
     * @return          connected FTPClient
     * @throws Exception
     */
	abstract public FTPClientInterface connect() throws Exception;
}
