/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.auth;

import com.enonic.xp.lib.common.PrincipalMapper;
import com.enonic.xp.script.serializer.MapGenerator;
import com.enonic.xp.script.serializer.MapSerializable;
import com.enonic.xp.security.Principal;
import com.enonic.xp.security.Principals;

public final class PrincipalsResultMapper
implements MapSerializable {
    private final Principals principals;
    private final long total;
    private final boolean detailed;

    public PrincipalsResultMapper(Principals principals, long total) {
        this(principals, total, false);
    }

    public PrincipalsResultMapper(Principals principals, long total, boolean detailed) {
        this.principals = principals;
        this.total = total;
        this.detailed = detailed;
    }

    public void serialize(MapGenerator gen) {
        gen.value("total", (Object)this.total);
        gen.value("count", (Object)this.principals.getSize());
        this.serialize(gen, this.principals);
    }

    private void serialize(MapGenerator gen, Principals principals) {
        gen.array("hits");
        for (Principal principal : principals) {
            gen.map();
            new PrincipalMapper(principal, this.detailed).serialize(gen);
            gen.end();
        }
        gen.end();
    }
}

