/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.auth;

import com.enonic.xp.convert.Converters;
import com.enonic.xp.lib.common.PrincipalMapper;
import com.enonic.xp.script.ScriptValue;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.enonic.xp.security.EditableGroup;
import com.enonic.xp.security.Principal;
import com.enonic.xp.security.PrincipalKey;
import com.enonic.xp.security.SecurityService;
import com.enonic.xp.security.UpdateGroupParams;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public final class ModifyGroupHandler
implements ScriptBean {
    private Supplier<SecurityService> securityService;
    private ScriptValue editor;
    private PrincipalKey principalKey;

    public void setEditor(ScriptValue editor) {
        this.editor = editor;
    }

    public void setPrincipalKey(String principalKey) {
        this.principalKey = principalKey == null ? null : PrincipalKey.from((String)principalKey);
    }

    public PrincipalMapper modifyGroup() {
        Optional existingGroup = this.securityService.get().getGroup(this.principalKey);
        if (existingGroup.isPresent()) {
            UpdateGroupParams params = UpdateGroupParams.create().groupKey(this.principalKey).editor(this::newGroupEditor).build();
            return new PrincipalMapper((Principal)this.securityService.get().updateGroup(params));
        }
        return null;
    }

    private void newGroupEditor(EditableGroup edit) {
        ScriptValue value = this.editor.call(new Object[]{new PrincipalMapper((Principal)edit.source)});
        if (value != null) {
            this.updateGroup(edit, value.getMap());
        }
    }

    private void updateGroup(EditableGroup target, Map map) {
        String description;
        String displayName = (String)Converters.convert(map.get("displayName"), String.class);
        if (displayName != null) {
            target.displayName = displayName;
        }
        if ((description = (String)Converters.convert(map.get("description"), String.class)) != null) {
            target.description = description;
        }
    }

    public void initialize(BeanContext context) {
        this.securityService = context.getService(SecurityService.class);
    }
}

