/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.auth;

import com.enonic.xp.context.Context;
import com.enonic.xp.context.LocalScope;
import com.enonic.xp.lib.auth.LoginResultMapper;
import com.enonic.xp.portal.PortalRequest;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.enonic.xp.security.IdProviderKey;
import com.enonic.xp.security.SecurityService;
import com.enonic.xp.security.auth.AuthenticationInfo;
import com.enonic.xp.security.auth.AuthenticationToken;
import com.enonic.xp.security.auth.EmailPasswordAuthToken;
import com.enonic.xp.security.auth.UsernamePasswordAuthToken;
import com.enonic.xp.security.auth.VerifiedEmailAuthToken;
import com.enonic.xp.security.auth.VerifiedUsernameAuthToken;
import com.enonic.xp.session.Session;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.http.HttpSession;

public final class LoginHandler
implements ScriptBean {
    private String user;
    private String password;
    private boolean skipAuth;
    private String[] idProvider;
    private Integer sessionTimeout;
    private Scope scope;
    private Supplier<SecurityService> securityServiceSupplier;
    private Supplier<Context> context;
    private Supplier<PortalRequest> portalRequestSupplier;

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSkipAuth(boolean skipAuth) {
        this.skipAuth = skipAuth;
    }

    public void setIdProvider(String[] idProvider) {
        this.idProvider = idProvider;
    }

    public void setSessionTimeout(Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setScope(String scope) {
        this.scope = Scope.valueOf(scope);
    }

    public LoginResultMapper login() {
        AuthenticationInfo authInfo = this.attemptLogin();
        if (authInfo.isAuthenticated()) {
            switch (this.scope) {
                case NONE: {
                    break;
                }
                case REQUEST: {
                    this.context.get().getLocalScope().setAttribute((Object)authInfo);
                    break;
                }
                default: {
                    this.createSession(authInfo);
                }
            }
            return new LoginResultMapper(authInfo);
        }
        return new LoginResultMapper(authInfo, "Access Denied");
    }

    private void createSession(AuthenticationInfo authInfo) {
        LocalScope localScope = this.context.get().getLocalScope();
        Session session = localScope.getSession();
        if (session != null) {
            Map attributes = session.getAttributes();
            session.invalidate();
            Session newSession = localScope.getSession();
            if (newSession != null) {
                attributes.forEach((arg_0, arg_1) -> ((Session)newSession).setAttribute(arg_0, arg_1));
                session.setAttribute((Object)authInfo);
                if (this.sessionTimeout != null) {
                    this.setSessionTimeout();
                }
            }
        }
    }

    private AuthenticationInfo attemptLogin() {
        if (this.idProvider == null || this.idProvider.length == 0) {
            return this.authenticate(null);
        }
        for (String uStore : this.idProvider) {
            AuthenticationInfo authInfo = this.authenticate(IdProviderKey.from((String)uStore));
            if (!authInfo.isAuthenticated()) continue;
            return authInfo;
        }
        return AuthenticationInfo.unAuthenticated();
    }

    private AuthenticationInfo authenticate(IdProviderKey idProvider) {
        VerifiedEmailAuthToken authToken;
        AuthenticationInfo authInfo = AuthenticationInfo.unAuthenticated();
        if (this.isValidEmail(this.user)) {
            if (this.skipAuth) {
                VerifiedEmailAuthToken verifiedEmailAuthToken = new VerifiedEmailAuthToken();
                verifiedEmailAuthToken.setEmail(this.user);
                verifiedEmailAuthToken.setIdProvider(idProvider);
                authToken = verifiedEmailAuthToken;
            } else {
                EmailPasswordAuthToken emailAuthToken = new EmailPasswordAuthToken();
                emailAuthToken.setEmail(this.user);
                emailAuthToken.setPassword(this.password);
                emailAuthToken.setIdProvider(idProvider);
                authToken = emailAuthToken;
            }
            authInfo = this.securityServiceSupplier.get().authenticate((AuthenticationToken)authToken);
        }
        if (!authInfo.isAuthenticated()) {
            if (this.skipAuth) {
                VerifiedUsernameAuthToken verifiedUsernameAuthToken = new VerifiedUsernameAuthToken();
                verifiedUsernameAuthToken.setUsername(this.user);
                verifiedUsernameAuthToken.setIdProvider(idProvider);
                authToken = verifiedUsernameAuthToken;
            } else {
                UsernamePasswordAuthToken usernameAuthToken = new UsernamePasswordAuthToken();
                usernameAuthToken.setUsername(this.user);
                usernameAuthToken.setPassword(this.password);
                usernameAuthToken.setIdProvider(idProvider);
                authToken = usernameAuthToken;
            }
            authInfo = this.securityServiceSupplier.get().authenticate((AuthenticationToken)authToken);
        }
        return authInfo;
    }

    private boolean isValidEmail(String value) {
        return value != null && value.chars().filter(ch -> ch == 64).count() == 1L;
    }

    private void setSessionTimeout() {
        HttpSession httpSession;
        PortalRequest portalRequest = this.portalRequestSupplier.get();
        if (portalRequest != null && (httpSession = portalRequest.getRawRequest().getSession()) != null) {
            httpSession.setMaxInactiveInterval(this.sessionTimeout.intValue());
        }
    }

    public void initialize(BeanContext context) {
        this.securityServiceSupplier = context.getService(SecurityService.class);
        this.context = context.getBinding(Context.class);
        this.portalRequestSupplier = context.getBinding(PortalRequest.class);
    }

    private static enum Scope {
        SESSION,
        REQUEST,
        NONE;

    }
}

