/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.auth;

import com.enonic.xp.data.PropertySet;
import com.enonic.xp.data.PropertyTree;
import com.enonic.xp.lib.common.PropertyTreeMapper;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.enonic.xp.security.PrincipalKey;
import com.enonic.xp.security.SecurityService;
import com.enonic.xp.security.User;
import java.util.Optional;
import java.util.function.Supplier;

public final class GetProfileHandler
implements ScriptBean {
    private Supplier<SecurityService> securityService;
    private PrincipalKey key;
    private String scope;

    public void setKey(String key) {
        this.key = PrincipalKey.from((String)key);
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public PropertyTreeMapper execute() {
        PropertyTree profile;
        Optional user = this.securityService.get().getUser(this.key);
        if (user.isPresent() && (profile = ((User)user.get()).getProfile()) != null) {
            if (this.scope == null) {
                return new PropertyTreeMapper(profile);
            }
            PropertySet scopedProfile = profile.getSet(this.scope);
            return scopedProfile == null ? null : new PropertyTreeMapper(scopedProfile.toTree());
        }
        return null;
    }

    public void initialize(BeanContext context) {
        this.securityService = context.getService(SecurityService.class);
    }
}

