/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.auth;

import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.enonic.xp.security.PrincipalKey;
import com.enonic.xp.security.PrincipalNotFoundException;
import com.enonic.xp.security.SecurityService;
import java.util.function.Supplier;

public final class DeletePrincipalHandler
implements ScriptBean {
    private PrincipalKey principalKey;
    private Supplier<SecurityService> securityService;

    public void setPrincipalKey(String principalKey) {
        this.principalKey = PrincipalKey.from((String)principalKey);
    }

    public boolean deletePrincipal() {
        if (PrincipalKey.ofAnonymous().equals((Object)this.principalKey) || PrincipalKey.ofSuperUser().equals((Object)this.principalKey)) {
            throw new IllegalArgumentException("Not allowed to delete principal [" + String.valueOf(this.principalKey) + "]");
        }
        try {
            this.securityService.get().deletePrincipal(this.principalKey);
            return true;
        }
        catch (PrincipalNotFoundException principalNotFoundException) {
            return false;
        }
    }

    public void initialize(BeanContext context) {
        this.securityService = context.getService(SecurityService.class);
    }
}

