/*
 * Decompiled with CFR 0.152.
 */
package com.empyr.api.util;

import com.empyr.api.Request;
import com.empyr.api.model.RestMeta;
import com.empyr.api.model.RestResponse;
import com.empyr.api.util.ApiJacksonObjectMapper;
import com.empyr.api.util.RequestAdapter;
import com.empyr.api.util.RestUrlDeSerializer;
import com.empyr.api.util.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JacksonRequestAdapter
implements RequestAdapter {
    private static final transient Log log = LogFactory.getLog(JacksonRequestAdapter.class);
    private ObjectMapper mapper = ApiJacksonObjectMapper.getInstance(null, new RestUrlDeSerializer());

    @Override
    public <T> void adapt(Request<T> r, String strToAdapt) {
        try {
            JsonNode tree = this.mapper.readTree(strToAdapt);
            RestResponse rr = new RestResponse();
            rr.meta = (RestMeta)this.mapper.convertValue((Object)tree.get("meta"), RestMeta.class);
            Map<String, Object> expects = r.getExpected();
            HashMap<String, Object> response = new HashMap<String, Object>();
            JsonNode responseTree = tree.get("response");
            for (Map.Entry<String, Object> entry : expects.entrySet()) {
                Object value = null;
                if (entry.getValue() instanceof TypeReference) {
                    JavaType type = TypeFactory.defaultInstance().constructType(((TypeReference)entry.getValue()).getType());
                    value = this.mapper.convertValue((Object)responseTree.get(entry.getKey()), type);
                } else {
                    Class clazz = (Class)entry.getValue();
                    value = this.mapper.convertValue((Object)responseTree.get(entry.getKey()), clazz);
                }
                if (value == null) continue;
                response.put(entry.getKey(), value);
            }
            if (response.size() > 1) {
                rr.response = response;
            } else if (response.size() == 1) {
                rr.response = response.entrySet().iterator().next().getValue();
            }
            r.setResponse(rr);
        }
        catch (Exception e) {
            log.warn((Object)("Exception caught trying to parse response: " + strToAdapt), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T adapt(Class<T> clazz, String response) {
        try {
            return (T)this.mapper.readValue(response, clazz);
        }
        catch (Exception e) {
            log.warn((Object)("Exception caught trying to parse response: " + response), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

