/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.connector.spring;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.emc.ecs.connector.S3ServiceInfo;
import com.emc.ecs.connector.spring.S3Connector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.service.AbstractServiceConnectorCreator;
import org.springframework.cloud.service.ServiceConnectorConfig;

public class S3ServiceConnectorCreator
extends AbstractServiceConnectorCreator<S3Connector, S3ServiceInfo> {
    private static Log log = LogFactory.getLog(S3ServiceConnectorCreator.class);

    public S3Connector create(S3ServiceInfo serviceInfo, ServiceConnectorConfig serviceConnectorConfig) {
        BasicAWSCredentials credentials = new BasicAWSCredentials(serviceInfo.getAccessKey(), serviceInfo.getSecretKey());
        AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
        AwsClientBuilder.EndpointConfiguration endpointConfig = new AwsClientBuilder.EndpointConfiguration(serviceInfo.getEndpoint(), Region.getRegion((Regions)Regions.DEFAULT_REGION).getName());
        AmazonS3 amazonS3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(endpointConfig)).withCredentials((AWSCredentialsProvider)credentialsProvider)).enablePathStyleAccess()).build();
        if (serviceInfo.getBucket() != null) {
            log.debug((Object)("Creating connector addressing ECS bucket: " + serviceInfo.getBucket()));
            return new S3Connector(amazonS3, serviceInfo.getEndpoint(), serviceInfo.getBucket());
        }
        log.debug((Object)"Creating connector addressing ECS namespace.");
        return new S3Connector(amazonS3, serviceInfo.getEndpoint());
    }
}

