/*
 * Decompiled with CFR 0.152.
 */
package com.emc.rest.smart;

import com.emc.rest.smart.OctetStreamXmlProvider;
import com.emc.rest.smart.PollingDaemon;
import com.emc.rest.smart.SizeOverrideWriter;
import com.emc.rest.smart.SmartConfig;
import com.emc.rest.smart.SmartFilter;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.ApacheHttpClient4Handler;
import com.sun.jersey.core.impl.provider.entity.ByteArrayProvider;
import com.sun.jersey.core.impl.provider.entity.FileProvider;
import com.sun.jersey.core.impl.provider.entity.InputStreamProvider;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmartClientFactory {
    private static final Logger log = LoggerFactory.getLogger(SmartClientFactory.class);
    public static final String DISABLE_APACHE_RETRY = "com.emc.rest.smart.disableApacheRetry";

    public static Client createSmartClient(SmartConfig smartConfig) {
        return SmartClientFactory.createSmartClient(smartConfig, (ClientHandler)SmartClientFactory.createApacheClientHandler(smartConfig));
    }

    public static Client createSmartClient(SmartConfig smartConfig, ClientHandler clientHandler) {
        Client client = SmartClientFactory.createStandardClient(smartConfig, clientHandler);
        client.addFilter((ClientFilter)new SmartFilter(smartConfig));
        PollingDaemon pollingDaemon = new PollingDaemon(smartConfig);
        pollingDaemon.start();
        client.getProperties().put("com.emc.rest.smart.pollingDaemon", pollingDaemon);
        return client;
    }

    public static Client createStandardClient(SmartConfig smartConfig) {
        return SmartClientFactory.createStandardClient(smartConfig, (ClientHandler)SmartClientFactory.createApacheClientHandler(smartConfig));
    }

    public static Client createStandardClient(SmartConfig smartConfig, ClientHandler clientHandler) {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        for (String propName : smartConfig.getProperties().keySet()) {
            clientConfig.getProperties().put(propName, smartConfig.getProperty(propName));
        }
        clientConfig.getClasses().remove(ByteArrayProvider.class);
        clientConfig.getClasses().remove(FileProvider.class);
        clientConfig.getClasses().remove(InputStreamProvider.class);
        clientConfig.getClasses().add(SizeOverrideWriter.ByteArray.class);
        clientConfig.getClasses().add(SizeOverrideWriter.File.class);
        clientConfig.getClasses().add(SizeOverrideWriter.SizedInputStream.class);
        clientConfig.getClasses().add(SizeOverrideWriter.InputStream.class);
        clientConfig.getClasses().add(ByteArrayProvider.class);
        clientConfig.getClasses().add(FileProvider.class);
        clientConfig.getClasses().add(InputStreamProvider.class);
        clientConfig.getClasses().add(OctetStreamXmlProvider.class);
        JacksonJaxbJsonProvider jsonProvider = new JacksonJaxbJsonProvider();
        jsonProvider.addUntouchable(InputStream.class);
        jsonProvider.addUntouchable(OutputStream.class);
        jsonProvider.addUntouchable(File.class);
        clientConfig.getSingletons().add(jsonProvider);
        return new Client(clientHandler, (ClientConfig)clientConfig);
    }

    public static void destroy(Client client) {
        PollingDaemon pollingDaemon = (PollingDaemon)client.getProperties().get("com.emc.rest.smart.pollingDaemon");
        if (pollingDaemon != null) {
            log.debug("terminating polling daemon");
            pollingDaemon.terminate();
            if (pollingDaemon.getSmartConfig().getHostListProvider() != null) {
                log.debug("destroying host list provider");
                pollingDaemon.getSmartConfig().getHostListProvider().destroy();
            }
        }
        log.debug("destroying Jersey client");
        client.destroy();
    }

    static ApacheHttpClient4Handler createApacheClientHandler(SmartConfig smartConfig) {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(999);
        connectionManager.setMaxTotal(999);
        clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.connectionManager", connectionManager);
        if (smartConfig.getProxyUri() != null) {
            clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", smartConfig.getProxyUri());
        }
        if (smartConfig.getProxyUser() != null) {
            clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyUsername", smartConfig.getProxyUser());
        }
        if (smartConfig.getProxyPass() != null) {
            clientConfig.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyPassword", smartConfig.getProxyPass());
        }
        for (String propName : smartConfig.getProperties().keySet()) {
            clientConfig.getProperties().put(propName, smartConfig.getProperty(propName));
        }
        ApacheHttpClient4Handler handler = ApacheHttpClient4.create((ClientConfig)clientConfig).getClientHandler();
        if (smartConfig.getProperty(DISABLE_APACHE_RETRY) != null) {
            AbstractHttpClient httpClient = (AbstractHttpClient)handler.getHttpClient();
            httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        }
        return handler;
    }

    private SmartClientFactory() {
    }
}

