/*
 * Decompiled with CFR 0.152.
 */
package com.emc.rest.smart;

import com.emc.rest.smart.SizedInputStreamWriter;
import com.sun.jersey.core.impl.provider.entity.ByteArrayProvider;
import com.sun.jersey.core.impl.provider.entity.FileProvider;
import com.sun.jersey.core.impl.provider.entity.InputStreamProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;

public class SizeOverrideWriter<T>
implements MessageBodyWriter<T> {
    private static final ThreadLocal<Long> entitySize = new ThreadLocal();
    private MessageBodyWriter<T> delegate;

    public static Long getEntitySize() {
        return entitySize.get();
    }

    public static void setEntitySize(Long size) {
        entitySize.set(size);
    }

    public SizeOverrideWriter(MessageBodyWriter<T> delegate) {
        this.delegate = delegate;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.delegate.isWriteable(type, genericType, annotations, mediaType);
    }

    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Long size = entitySize.get();
        if (size != null) {
            entitySize.remove();
            return size;
        }
        return this.delegate.getSize(t, type, genericType, annotations, mediaType);
    }

    public void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.delegate.writeTo(t, type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    @Produces(value={"application/octet-stream", "*/*"})
    public static class SizedInputStream
    extends SizeOverrideWriter<com.emc.rest.util.SizedInputStream> {
        private static final SizedInputStreamWriter delegate = new SizedInputStreamWriter();

        public SizedInputStream() {
            super(delegate);
        }
    }

    @Produces(value={"application/octet-stream", "*/*"})
    public static class InputStream
    extends SizeOverrideWriter<java.io.InputStream> {
        private static final InputStreamProvider delegate = new InputStreamProvider();

        public InputStream() {
            super(delegate);
        }
    }

    @Produces(value={"application/octet-stream", "*/*"})
    public static class File
    extends SizeOverrideWriter<java.io.File> {
        private static final FileProvider delegate = new FileProvider();

        public File() {
            super(delegate);
        }
    }

    @Produces(value={"application/octet-stream", "*/*"})
    public static class ByteArray
    extends SizeOverrideWriter<byte[]> {
        private static final ByteArrayProvider delegate = new ByteArrayProvider();

        public ByteArray() {
            super(delegate);
        }
    }
}

