/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.encryption;

import com.emc.codec.EncodeInputStream;
import com.emc.codec.encryption.EncryptionException;
import com.emc.codec.encryption.EncryptionMetadata;
import com.emc.codec.util.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;

public class EncryptionInputStream
extends EncodeInputStream<EncryptionMetadata> {
    private EncryptionMetadata metadata;
    boolean closed = false;
    private DigestInputStream digestStream;
    private CountingInputStream counterStream;

    public EncryptionInputStream(InputStream originalStream, String encodeSpec, Cipher cipher, String encryptedKey) {
        super(originalStream);
        this.metadata = new EncryptionMetadata(encodeSpec);
        this.metadata.setEncryptedKey(encryptedKey);
        this.metadata.setInitVector(cipher.getIV());
        try {
            this.counterStream = new CountingInputStream(originalStream);
            this.digestStream = new DigestInputStream(this.counterStream, MessageDigest.getInstance("SHA1"));
            this.in = new CipherInputStream(this.digestStream, cipher);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Unable to initialize digest", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
        this.metadata.setOriginalSize(this.counterStream.getByteCount());
        this.metadata.setOriginalDigest(this.digestStream.getMessageDigest().digest());
        this.notifyListeners();
    }

    @Override
    public EncryptionMetadata getEncodeMetadata() {
        return this.metadata;
    }
}

