/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.compression.lzma;

import com.emc.codec.compression.CompressionException;
import com.emc.codec.compression.CompressionInputStream;
import com.emc.codec.compression.lzma.EncoderThread;
import com.emc.codec.compression.lzma.LzmaProfile;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class LzmaEncodeInputStream
extends CompressionInputStream {
    private InputStream prePipeStream;
    private LzmaProfile compressionProfile;
    private int pipeBufferSize;
    private EncoderThread encoderThread;

    public LzmaEncodeInputStream(InputStream in, String encodeSpec, LzmaProfile compressionProfile, int pipeBufferSize) {
        super(in, encodeSpec);
        this.compressionProfile = compressionProfile;
        this.pipeBufferSize = pipeBufferSize;
        this.initStreams(in);
    }

    @Override
    protected InputStream getCompressionStream(InputStream input) throws IOException {
        this.prePipeStream = input;
        PipedInputStream inputPipe = new PipedInputStream(this.pipeBufferSize);
        PipedOutputStream outputPipe = new PipedOutputStream(inputPipe);
        this.encoderThread = new EncoderThread(this.compressionProfile, input, outputPipe);
        this.encoderThread.start();
        return inputPipe;
    }

    @Override
    public int read() throws IOException {
        this.checkForError();
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkForError();
        return super.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkForError();
        return super.read(b);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.prePipeStream.close();
        this.encoderThread = null;
    }

    protected void checkForError() {
        if (this.encoderThread != null && this.encoderThread.isErrorSet()) {
            Throwable t = this.encoderThread.getError();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new CompressionException("Compression error", t);
        }
    }
}

