/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.compression.lzma;

import com.emc.codec.AbstractCodec;
import com.emc.codec.EncodeInputStream;
import com.emc.codec.EncodeOutputStream;
import com.emc.codec.compression.CompressionMetadata;
import com.emc.codec.compression.CompressionUtil;
import com.emc.codec.compression.lzma.LzmaDecodeInputStream;
import com.emc.codec.compression.lzma.LzmaDecodeOutputStream;
import com.emc.codec.compression.lzma.LzmaEncodeInputStream;
import com.emc.codec.compression.lzma.LzmaEncodeOutputStream;
import com.emc.codec.compression.lzma.LzmaProfile;
import com.emc.codec.util.CodecUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class LzmaCodec
extends AbstractCodec<CompressionMetadata> {
    public static final String SUBSPEC = "LZMA";
    public static final int PRIORITY = 100;
    public static final String PROP_PIPE_BUFFER_SIZE = "com.emc.codec.lzma.LzmaCodec.pipeBufferSize";
    public static final String PROP_CUSTOM_PROFILE = "com.emc.codec.lzma.LzmaCodec.customProfile";
    public static final int DEFAULT_PIPE_BUFFER_SIZE = 65536;

    public static String encodeSpec(int compressionLevel) {
        return CompressionUtil.getEncodeSpec(SUBSPEC, compressionLevel);
    }

    public static int getPipeBufferSize(Map<String, Object> codecProperties) {
        return CodecUtil.getCodecProperty(PROP_PIPE_BUFFER_SIZE, codecProperties, 65536);
    }

    public static void setPipeBufferSize(Map<String, Object> codecProperties, int pipeBufferSize) {
        codecProperties.put(PROP_PIPE_BUFFER_SIZE, pipeBufferSize);
    }

    public static LzmaProfile getCustomProfile(Map<String, Object> codecProperties) {
        return CodecUtil.getCodecProperty(PROP_CUSTOM_PROFILE, codecProperties, null);
    }

    public static void setCustomProfile(Map<String, Object> codecProperties, LzmaProfile customProfile) {
        codecProperties.put(PROP_CUSTOM_PROFILE, customProfile);
    }

    @Override
    public boolean canProcess(String encodeSpec) {
        String algorithm = CodecUtil.getEncodeAlgorithm(encodeSpec);
        return "COMP".equals(CodecUtil.getEncodeType(encodeSpec)) && algorithm != null && algorithm.startsWith(SUBSPEC);
    }

    @Override
    public String getDefaultEncodeSpec() {
        return LzmaCodec.encodeSpec(5);
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public CompressionMetadata createEncodeMetadata(String encodeSpec, Map<String, String> metadata) {
        return new CompressionMetadata(encodeSpec, metadata);
    }

    @Override
    public long getDecodedSize(CompressionMetadata metadata) {
        return metadata.getOriginalSize();
    }

    @Override
    public OutputStream getDecodingStream(OutputStream originalStream, CompressionMetadata metadata, Map<String, Object> codecProperties) {
        return new LzmaDecodeOutputStream(originalStream, LzmaCodec.getPipeBufferSize(codecProperties));
    }

    @Override
    public InputStream getDecodingStream(InputStream originalStream, CompressionMetadata metadataetadata, Map<String, Object> codecProperties) {
        return new LzmaDecodeInputStream(originalStream, LzmaCodec.getPipeBufferSize(codecProperties));
    }

    @Override
    public boolean isSizePredictable() {
        return false;
    }

    @Override
    public long getEncodedSize(long originalSize, String encodeSpec, Map<String, Object> codecProperties) {
        throw new UnsupportedOperationException("compressed size is unpredictable");
    }

    @Override
    public EncodeOutputStream<CompressionMetadata> getEncodingStream(OutputStream originalStream, String encodeSpec, Map<String, Object> codecProperties) {
        if (!this.canProcess(encodeSpec)) {
            throw new IllegalArgumentException("cannot process " + encodeSpec);
        }
        LzmaProfile profile = LzmaCodec.getCustomProfile(codecProperties);
        if (profile == null) {
            int compressionLevel = CompressionUtil.getCompressionLevel(encodeSpec, 5);
            profile = LzmaProfile.fromCompressionLevel(compressionLevel);
        }
        return new LzmaEncodeOutputStream(originalStream, encodeSpec, profile, LzmaCodec.getPipeBufferSize(codecProperties));
    }

    @Override
    public EncodeInputStream<CompressionMetadata> getEncodingStream(InputStream originalStream, String encodeSpec, Map<String, Object> codecProperties) {
        if (!this.canProcess(encodeSpec)) {
            throw new IllegalArgumentException("cannot process " + encodeSpec);
        }
        LzmaProfile profile = LzmaCodec.getCustomProfile(codecProperties);
        if (profile == null) {
            int compressionLevel = CompressionUtil.getCompressionLevel(encodeSpec, 5);
            profile = LzmaProfile.fromCompressionLevel(compressionLevel);
        }
        return new LzmaEncodeInputStream(originalStream, encodeSpec, profile, LzmaCodec.getPipeBufferSize(codecProperties));
    }
}

