/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.compression.lzma;

import SevenZip.Compression.LZMA.Decoder;
import com.emc.codec.compression.CompressionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(DecoderThread.class);
    public static final ThreadGroup THREAD_GROUP = new ThreadGroup("LZMA-Decompress");
    private InputStream input;
    private OutputStream output;
    private boolean errorSet = false;
    private Throwable error;

    public DecoderThread(InputStream input, OutputStream output) throws IOException {
        super(THREAD_GROUP, (Runnable)null);
        this.setDaemon(true);
        this.input = input;
        this.output = output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Decoder decoder = new Decoder();
            byte[] properties = new byte[5];
            int c = this.input.read(properties);
            if (c != properties.length) {
                throw new CompressionException("Unable to read compression settings from stream");
            }
            if (!decoder.SetDecoderProperties(properties)) {
                throw new CompressionException("LZMA decoder rejected compression settings from stream");
            }
            decoder.Code(this.input, this.output, -1L);
        }
        catch (Throwable t) {
            log.error("error during decompression", t);
            this.error = t;
            this.errorSet = true;
        }
        finally {
            try {
                if (this.input instanceof PipedInputStream) {
                    this.input.close();
                }
            }
            catch (Throwable t) {
                log.warn("could not close input stream", t);
            }
            try {
                if (this.output instanceof PipedOutputStream) {
                    this.output.close();
                }
            }
            catch (Throwable t) {
                log.warn("could not close output stream", t);
            }
        }
    }

    public boolean isErrorSet() {
        return this.errorSet;
    }

    public Throwable getError() {
        return this.error;
    }
}

