/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.compression;

import com.emc.codec.util.CodecUtil;

public class CompressionUtil {
    public static int getCompressionLevel(String encodeSpec, int defaultLevel) {
        int level = defaultLevel;
        String algorithm = CodecUtil.getEncodeAlgorithm(encodeSpec);
        if (algorithm != null && algorithm.contains("/")) {
            level = Integer.parseInt(algorithm.substring(algorithm.indexOf("/") + 1));
        }
        CompressionUtil.validateCompressionLevel(level);
        return level;
    }

    public static String getEncodeSpec(String algorithm, int compressionLevel) {
        CompressionUtil.validateCompressionLevel(compressionLevel);
        return CodecUtil.getEncodeSpec("COMP", algorithm + "/" + compressionLevel);
    }

    public static void validateCompressionLevel(int compressionLevel) {
        if (compressionLevel > 9 || compressionLevel < 0) {
            throw new IllegalArgumentException("Invalid compression level: " + compressionLevel);
        }
    }
}

