/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.common.util;

import com.embabel.common.util.ConsoleFontInfoEx;
import com.embabel.common.util.ExcludeFromJacocoGeneratedReport;
import com.embabel.common.util.Kernel32Extended;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExcludeFromJacocoGeneratedReport(reason="Windows-specific operations")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/embabel/common/util/WinUtils;", "", "<init>", "()V", "Companion", "embabel-common-util"})
public final class WinUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int UTF8_CODEPAGE = 65001;

    @JvmStatic
    public static final boolean IS_OS_WINDOWS() {
        return Companion.IS_OS_WINDOWS();
    }

    @JvmStatic
    public static final void CHCP_TO_UTF8() {
        Companion.CHCP_TO_UTF8();
    }

    @JvmStatic
    public static final int ACTIVE_CONSOLE_CODEPAGE() {
        return Companion.ACTIVE_CONSOLE_CODEPAGE();
    }

    @JvmStatic
    public static final boolean ASCII_TABLE_SUPPORTED() {
        return Companion.ASCII_TABLE_SUPPORTED();
    }

    @JvmStatic
    public static final boolean SET_CASCADIA_CODE_FONT(@Nullable Short fontSize) {
        return Companion.SET_CASCADIA_CODE_FONT(fontSize);
    }

    @JvmStatic
    public static final boolean SETUP_OPTIMAL_CONSOLE() {
        return Companion.SETUP_OPTIMAL_CONSOLE();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\u0005H\u0007J\b\u0010\u000b\u001a\u00020\u0007H\u0007J\u0019\u0010\f\u001a\u00020\u00072\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0007H\u0007J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/embabel/common/util/WinUtils$Companion;", "", "<init>", "()V", "UTF8_CODEPAGE", "", "IS_OS_WINDOWS", "", "CHCP_TO_UTF8", "", "ACTIVE_CONSOLE_CODEPAGE", "ASCII_TABLE_SUPPORTED", "SET_CASCADIA_CODE_FONT", "fontSize", "", "(Ljava/lang/Short;)Z", "SETUP_OPTIMAL_CONSOLE", "getCurrentConsoleFontSize", "kernel32Extended", "Lcom/embabel/common/util/Kernel32Extended;", "(Lcom/embabel/common/util/Kernel32Extended;)Ljava/lang/Short;", "setConsoleFont", "fontName", "", "embabel-common-util"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean IS_OS_WINDOWS() {
            return SystemUtils.IS_OS_WINDOWS;
        }

        @JvmStatic
        public final void CHCP_TO_UTF8() {
            Kernel32.INSTANCE.SetConsoleCP(65001);
            Kernel32.INSTANCE.SetConsoleOutputCP(65001);
            System.out.println((Object)("Active Console Code Page: " + Kernel32.INSTANCE.GetConsoleCP()));
        }

        @JvmStatic
        public final int ACTIVE_CONSOLE_CODEPAGE() {
            return Kernel32.INSTANCE.GetConsoleCP();
        }

        @JvmStatic
        public final boolean ASCII_TABLE_SUPPORTED() {
            if (this.IS_OS_WINDOWS()) {
                return 65001 == this.ACTIVE_CONSOLE_CODEPAGE();
            }
            return true;
        }

        @JvmStatic
        public final boolean SET_CASCADIA_CODE_FONT(@Nullable Short fontSize) {
            boolean bl;
            if (!this.IS_OS_WINDOWS()) {
                System.out.println((Object)"Font switching only supported on Windows");
                return false;
            }
            Kernel32Extended kernel32Extended = Kernel32Extended.Companion.getINSTANCE();
            if (kernel32Extended == null) {
                System.out.println((Object)"Windows font APIs not available");
                return false;
            }
            try {
                ConsoleFontInfoEx consoleFontInfoEx;
                this.CHCP_TO_UTF8();
                WinNT.HANDLE consoleHandle = Kernel32.INSTANCE.GetStdHandle(-11);
                if (consoleHandle == null || consoleHandle.equals((Object)WinNT.INVALID_HANDLE_VALUE)) {
                    System.out.println((Object)"Failed to get console handle");
                    return false;
                }
                ConsoleFontInfoEx fontInfo = new ConsoleFontInfoEx();
                fontInfo.cbSize = fontInfo.size();
                if (!kernel32Extended.GetCurrentConsoleFontEx(consoleHandle, false, fontInfo)) {
                    System.out.println((Object)"Failed to get current font info");
                    return false;
                }
                Short s = fontSize;
                short targetFontSize = s != null ? s : fontInfo.dwFontSize.Y;
                ConsoleFontInfoEx $this$SET_CASCADIA_CODE_FONT_u24lambda_u240 = consoleFontInfoEx = fontInfo;
                boolean bl2 = false;
                $this$SET_CASCADIA_CODE_FONT_u24lambda_u240.cbSize = $this$SET_CASCADIA_CODE_FONT_u24lambda_u240.size();
                ArraysKt.fill$default((char[])$this$SET_CASCADIA_CODE_FONT_u24lambda_u240.FaceName, (char)'\u0000', (int)0, (int)0, (int)6, null);
                char[] cArray = "Cascadia Code".toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                ArraysKt.copyInto$default((char[])cArray, (char[])$this$SET_CASCADIA_CODE_FONT_u24lambda_u240.FaceName, (int)0, (int)0, (int)Math.min(13, $this$SET_CASCADIA_CODE_FONT_u24lambda_u240.FaceName.length - 1), (int)6, null);
                $this$SET_CASCADIA_CODE_FONT_u24lambda_u240.dwFontSize.X = 0;
                $this$SET_CASCADIA_CODE_FONT_u24lambda_u240.dwFontSize.Y = targetFontSize;
                $this$SET_CASCADIA_CODE_FONT_u24lambda_u240.FontWeight = 400;
                boolean success = kernel32Extended.SetCurrentConsoleFontEx(consoleHandle, false, fontInfo);
                if (success) {
                    String sizeMsg = fontSize == null ? "size preserved: " + targetFontSize : "size: " + targetFontSize;
                    System.out.println((Object)("\u2713 Console font changed to Cascadia Code (" + sizeMsg + ")"));
                } else {
                    System.out.println((Object)"\u2717 Failed to change console font to Cascadia Code");
                }
                bl = success;
            }
            catch (Exception e) {
                System.out.println((Object)("Error changing font: " + e.getMessage()));
                bl = false;
            }
            return bl;
        }

        public static /* synthetic */ boolean SET_CASCADIA_CODE_FONT$default(Companion companion, Short s, int n, Object object) {
            if ((n & 1) != 0) {
                s = null;
            }
            return companion.SET_CASCADIA_CODE_FONT(s);
        }

        @JvmStatic
        public final boolean SETUP_OPTIMAL_CONSOLE() {
            if (!this.IS_OS_WINDOWS()) {
                System.out.println((Object)"Console optimization only supported on Windows");
                return false;
            }
            Kernel32Extended kernel32Extended = Kernel32Extended.Companion.getINSTANCE();
            if (kernel32Extended == null) {
                System.out.println((Object)"Windows font APIs not available");
                return false;
            }
            Short s = this.getCurrentConsoleFontSize(kernel32Extended);
            short originalFontSize = s != null ? s : (short)16;
            String[] stringArray = new String[]{"Cascadia Code", "Cascadia Mono", "Consolas"};
            for (String font : stringArray) {
                if (!this.setConsoleFont(font, kernel32Extended, originalFontSize)) continue;
                System.out.println((Object)("\u2713 Console optimized with " + font + " font (size preserved: " + originalFontSize + ")"));
                return true;
            }
            System.out.println((Object)"\u2717 No suitable Unicode fonts found");
            return false;
        }

        private final Short getCurrentConsoleFontSize(Kernel32Extended kernel32Extended) {
            Short s;
            try {
                WinNT.HANDLE consoleHandle = Kernel32.INSTANCE.GetStdHandle(-11);
                if (consoleHandle == null || consoleHandle.equals((Object)WinNT.INVALID_HANDLE_VALUE)) {
                    return null;
                }
                ConsoleFontInfoEx fontInfo = new ConsoleFontInfoEx();
                fontInfo.cbSize = fontInfo.size();
                s = kernel32Extended.GetCurrentConsoleFontEx(consoleHandle, false, fontInfo) ? Short.valueOf(fontInfo.dwFontSize.Y) : null;
            }
            catch (Exception e) {
                s = null;
            }
            return s;
        }

        private final boolean setConsoleFont(String fontName, Kernel32Extended kernel32Extended, short fontSize) {
            boolean bl;
            try {
                ConsoleFontInfoEx consoleFontInfoEx;
                this.CHCP_TO_UTF8();
                WinNT.HANDLE consoleHandle = Kernel32.INSTANCE.GetStdHandle(-11);
                if (consoleHandle == null || consoleHandle.equals((Object)WinNT.INVALID_HANDLE_VALUE)) {
                    return false;
                }
                ConsoleFontInfoEx fontInfo = new ConsoleFontInfoEx();
                fontInfo.cbSize = fontInfo.size();
                if (!kernel32Extended.GetCurrentConsoleFontEx(consoleHandle, false, fontInfo)) {
                    return false;
                }
                ConsoleFontInfoEx $this$setConsoleFont_u24lambda_u241 = consoleFontInfoEx = fontInfo;
                boolean bl2 = false;
                $this$setConsoleFont_u24lambda_u241.cbSize = $this$setConsoleFont_u24lambda_u241.size();
                ArraysKt.fill$default((char[])$this$setConsoleFont_u24lambda_u241.FaceName, (char)'\u0000', (int)0, (int)0, (int)6, null);
                char[] cArray = fontName.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                ArraysKt.copyInto$default((char[])cArray, (char[])$this$setConsoleFont_u24lambda_u241.FaceName, (int)0, (int)0, (int)Math.min(fontName.length(), $this$setConsoleFont_u24lambda_u241.FaceName.length - 1), (int)6, null);
                $this$setConsoleFont_u24lambda_u241.dwFontSize.X = 0;
                $this$setConsoleFont_u24lambda_u241.dwFontSize.Y = fontSize;
                $this$setConsoleFont_u24lambda_u241.FontWeight = 400;
                bl = kernel32Extended.SetCurrentConsoleFontEx(consoleHandle, false, fontInfo);
            }
            catch (Exception e) {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

