/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.common.textio.template;

import com.embabel.common.textio.template.EscFilter;
import com.embabel.common.textio.template.InvalidTemplateException;
import com.embabel.common.textio.template.JinjaProperties;
import com.embabel.common.textio.template.NoSuchTemplateException;
import com.embabel.common.textio.template.TemplateErrorDetail;
import com.embabel.common.textio.template.TemplateRenderer;
import com.hubspot.jinjava.Jinjava;
import com.hubspot.jinjava.JinjavaConfig;
import com.hubspot.jinjava.interpret.FatalTemplateErrorsException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.RenderResult;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.loader.ResourceLocator;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.DigestUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0017B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002J$\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/embabel/common/textio/template/JinjavaTemplateRenderer;", "Lcom/embabel/common/textio/template/TemplateRenderer;", "jinja", "Lcom/embabel/common/textio/template/JinjaProperties;", "resourceLoader", "Lorg/springframework/core/io/ResourceLoader;", "<init>", "(Lcom/embabel/common/textio/template/JinjaProperties;Lorg/springframework/core/io/ResourceLoader;)V", "logger", "Lorg/slf4j/Logger;", "renderLiteralTemplate", "", "template", "model", "", "", "toTemplateErrorDetail", "Lcom/embabel/common/textio/template/TemplateErrorDetail;", "Lcom/hubspot/jinjava/interpret/TemplateError;", "renderLoadedTemplate", "templateName", "getLocation", "load", "SpringResourceLocator", "embabel-common-textio"})
@SourceDebugExtension(value={"SMAP\nJinjavaTemplateRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JinjavaTemplateRenderer.kt\ncom/embabel/common/textio/template/JinjavaTemplateRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n774#2:198\n865#2,2:199\n1557#2:201\n1628#2,3:202\n774#2:205\n865#2,2:206\n1863#2,2:208\n1557#2:210\n1628#2,3:211\n1#3:214\n*S KotlinDebug\n*F\n+ 1 JinjavaTemplateRenderer.kt\ncom/embabel/common/textio/template/JinjavaTemplateRenderer\n*L\n75#1:198\n75#1:199,2\n77#1:201\n77#1:202,3\n87#1:205\n87#1:206,2\n88#1:208,2\n94#1:210\n94#1:211,3\n*E\n"})
public final class JinjavaTemplateRenderer
implements TemplateRenderer {
    @NotNull
    private final JinjaProperties jinja;
    @NotNull
    private final ResourceLoader resourceLoader;
    @NotNull
    private final Logger logger;

    public JinjavaTemplateRenderer(@NotNull JinjaProperties jinja, @NotNull ResourceLoader resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)jinja, (String)"jinja");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        this.jinja = jinja;
        this.resourceLoader = resourceLoader;
        Logger logger = LoggerFactory.getLogger(JinjavaTemplateRenderer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    public /* synthetic */ JinjavaTemplateRenderer(JinjaProperties jinjaProperties, ResourceLoader resourceLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            jinjaProperties = new JinjaProperties("classpath:/prompts/", ".jinja", false);
        }
        if ((n & 2) != 0) {
            resourceLoader = (ResourceLoader)new DefaultResourceLoader();
        }
        this(jinjaProperties, resourceLoader);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String renderLiteralTemplate(@NotNull String template, @NotNull Map<String, ? extends Object> model) throws InvalidTemplateException {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        try {
            void $this$forEach$iv;
            Iterable errorDetails;
            TemplateError it;
            Object element$iv$iv;
            Iterator $this$filterTo$iv$iv;
            Jinjava jinjava;
            JinjavaConfig jcConfig = JinjavaConfig.newBuilder().withFailOnUnknownTokens(this.jinja.getFailOnUnknownTokens()).withTrimBlocks(true).build();
            Jinjava $this$renderLiteralTemplate_u24lambda_u240 = jinjava = new Jinjava(jcConfig);
            boolean bl = false;
            $this$renderLiteralTemplate_u24lambda_u240.registerFilter((Filter)new EscFilter());
            $this$renderLiteralTemplate_u24lambda_u240.setResourceLocator((ResourceLocator)new SpringResourceLocator());
            Jinjava jinjava2 = jinjava;
            RenderResult result = jinjava2.renderForResult(template, model);
            List list = result.getErrors();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getErrors(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                it = (TemplateError)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getSeverity() == TemplateError.ErrorType.FATAL)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List fatalErrors = (List)destination$iv$iv;
            if (!((Collection)fatalErrors).isEmpty()) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = fatalErrors;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    TemplateError bl2 = (TemplateError)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it2);
                    collection.add(this.toTemplateErrorDetail((TemplateError)it2));
                }
                errorDetails = (List)destination$iv$iv2;
                String errorSummary = CollectionsKt.joinToString$default((Iterable)errorDetails, (CharSequence)"; ", null, null, (int)0, null, JinjavaTemplateRenderer::renderLiteralTemplate$lambda$3, (int)30, null);
                throw new InvalidTemplateException("Template rendering failed: " + errorSummary, (List<TemplateErrorDetail>)errorDetails);
            }
            List list2 = result.getErrors();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getErrors(...)");
            errorDetails = list2;
            $i$f$filter = false;
            Iterable $i$f$map = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            Iterator $i$f$mapTo = $this$filterTo$iv$iv.iterator();
            while ($i$f$mapTo.hasNext()) {
                element$iv$iv = $i$f$mapTo.next();
                it = (TemplateError)element$iv$iv;
                boolean bl4 = false;
                if (!(it.getSeverity() != TemplateError.ErrorType.FATAL)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TemplateError error = (TemplateError)element$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNull((Object)error);
                this.logger.warn("Template warning: {}", (Object)this.toTemplateErrorDetail(error).format());
            }
            String string = result.getOutput();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutput(...)");
            return string;
        }
        catch (FatalTemplateErrorsException e) {
            void $this$mapTo$iv$iv;
            Iterable iterable = e.getErrors();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getErrors(...)");
            Iterable $this$map$iv = iterable;
            boolean $i$f$map = false;
            Iterable $i$f$forEach = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TemplateError element$iv$iv = (TemplateError)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(this.toTemplateErrorDetail((TemplateError)it));
            }
            List errorDetails = (List)destination$iv$iv;
            String errorSummary = CollectionsKt.joinToString$default((Iterable)errorDetails, (CharSequence)"; ", null, null, (int)0, null, JinjavaTemplateRenderer::renderLiteralTemplate$lambda$7, (int)30, null);
            throw new InvalidTemplateException("Fatal template error: " + errorSummary, errorDetails, e);
        }
        catch (InvalidTemplateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidTemplateException("Invalid template: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final TemplateErrorDetail toTemplateErrorDetail(TemplateError $this$toTemplateErrorDetail) {
        String string;
        String string2 = $this$toTemplateErrorDetail.getMessage();
        String string3 = string2;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMessage(...)");
        Integer n = $this$toTemplateErrorDetail.getLineno() > 0 ? Integer.valueOf($this$toTemplateErrorDetail.getLineno()) : null;
        Integer n2 = $this$toTemplateErrorDetail.getStartPosition() > 0 ? Integer.valueOf($this$toTemplateErrorDetail.getStartPosition()) : null;
        String string4 = $this$toTemplateErrorDetail.getFieldName();
        if (string4 != null) {
            void it;
            String string5;
            String string6 = string5 = string4;
            Integer n3 = n2;
            Integer n4 = n;
            String string7 = string3;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
            string3 = string7;
            n = n4;
            n2 = n3;
            string = bl2 ? string5 : null;
        } else {
            string = null;
        }
        TemplateError.ErrorType errorType = $this$toTemplateErrorDetail.getSeverity();
        String string8 = errorType != null ? errorType.name() : null;
        String string9 = string;
        Integer n5 = n2;
        Integer n6 = n;
        String string10 = string3;
        return new TemplateErrorDetail(string10, n6, n5, string9, string8);
    }

    @Override
    @NotNull
    public String renderLoadedTemplate(@NotNull String templateName, @NotNull Map<String, ? extends Object> model) throws NoSuchTemplateException, InvalidTemplateException {
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        String template = this.load(templateName);
        try {
            return this.renderLiteralTemplate(template, model);
        }
        catch (InvalidTemplateException ex) {
            throw new InvalidTemplateException("Invalid template at '" + templateName + "': " + ex.getMessage(), ex.getErrors(), (Throwable)((Object)ex));
        }
    }

    private final String getLocation(String template) {
        if (StringsKt.startsWith$default((String)template, (String)"classpath:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)template, (String)"file:", (boolean)false, (int)2, null)) {
            return template;
        }
        return this.jinja.getPrefix() + template + (StringsKt.contains$default((CharSequence)template, (CharSequence)this.jinja.getSuffix(), (boolean)false, (int)2, null) ? "" : this.jinja.getSuffix());
    }

    @Override
    @NotNull
    public String load(@NotNull String templateName) throws NoSuchTemplateException {
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        String expanded = this.getLocation(templateName);
        Resource resource = this.resourceLoader.getResource(expanded);
        Intrinsics.checkNotNullExpressionValue((Object)resource, (String)"getResource(...)");
        Resource resource2 = resource;
        if (!resource2.exists()) {
            throw new NoSuchTemplateException(templateName, resource2);
        }
        try {
            String template;
            String string = resource2.getContentAsString(Charset.defaultCharset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContentAsString(...)");
            String string2 = template = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            String string3 = DigestUtils.md5DigestAsHex((byte[])byArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"md5DigestAsHex(...)");
            String sha = string3;
            Object[] objectArray = new Object[]{templateName, sha, expanded};
            this.logger.debug("Loaded template {} with sha [{}] at location [{}]", objectArray);
            return template;
        }
        catch (IOException e) {
            throw new InvalidTemplateException("Can't read template at '" + expanded + "'", e);
        }
    }

    private static final CharSequence renderLiteralTemplate$lambda$3(TemplateErrorDetail it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.format();
    }

    private static final CharSequence renderLiteralTemplate$lambda$7(TemplateErrorDetail it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.format();
    }

    public JinjavaTemplateRenderer() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/embabel/common/textio/template/JinjavaTemplateRenderer$SpringResourceLocator;", "Lcom/hubspot/jinjava/loader/ResourceLocator;", "<init>", "(Lcom/embabel/common/textio/template/JinjavaTemplateRenderer;)V", "getString", "", "fullName", "encoding", "Ljava/nio/charset/Charset;", "interpreter", "Lcom/hubspot/jinjava/interpret/JinjavaInterpreter;", "embabel-common-textio"})
    private final class SpringResourceLocator
    implements ResourceLocator {
        @Nullable
        public String getString(@NotNull String fullName, @Nullable Charset encoding, @Nullable JinjavaInterpreter interpreter) {
            Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
            return JinjavaTemplateRenderer.this.load(fullName);
        }
    }
}

