/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.common.core.config;

import com.embabel.common.core.config.PropertyConflict;
import com.embabel.common.core.config.PropertySourceInfo;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\n\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\bH\u00c6\u0003J\u001b\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\nH\u00c6\u0003JI\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\nH\u00c6\u0001J\u0013\u0010'\u001a\u00020\u001f2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\u0017H\u00d6\u0001J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006+"}, d2={"Lcom/embabel/common/core/config/PropertyAnalysis;", "", "fileName", "", "sources", "", "Lcom/embabel/common/core/config/PropertySourceInfo;", "mergedProperties", "Ljava/util/Properties;", "conflicts", "", "Lcom/embabel/common/core/config/PropertyConflict;", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/Properties;Ljava/util/Map;)V", "getFileName", "()Ljava/lang/String;", "getSources", "()Ljava/util/List;", "getMergedProperties", "()Ljava/util/Properties;", "getConflicts", "()Ljava/util/Map;", "sourceCount", "", "getSourceCount", "()I", "propertyCount", "getPropertyCount", "conflictCount", "getConflictCount", "hasConflicts", "", "getHasConflicts", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "embabel-common-core"})
public final class PropertyAnalysis {
    @NotNull
    private final String fileName;
    @NotNull
    private final List<PropertySourceInfo> sources;
    @NotNull
    private final Properties mergedProperties;
    @NotNull
    private final Map<String, List<PropertyConflict>> conflicts;

    public PropertyAnalysis(@NotNull String fileName, @NotNull List<PropertySourceInfo> sources, @NotNull Properties mergedProperties, @NotNull Map<String, ? extends List<PropertyConflict>> conflicts) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)mergedProperties, (String)"mergedProperties");
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        this.fileName = fileName;
        this.sources = sources;
        this.mergedProperties = mergedProperties;
        this.conflicts = conflicts;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final List<PropertySourceInfo> getSources() {
        return this.sources;
    }

    @NotNull
    public final Properties getMergedProperties() {
        return this.mergedProperties;
    }

    @NotNull
    public final Map<String, List<PropertyConflict>> getConflicts() {
        return this.conflicts;
    }

    public final int getSourceCount() {
        return this.sources.size();
    }

    public final int getPropertyCount() {
        return this.mergedProperties.size();
    }

    public final int getConflictCount() {
        return this.conflicts.size();
    }

    public final boolean getHasConflicts() {
        return !this.conflicts.isEmpty();
    }

    @NotNull
    public final String component1() {
        return this.fileName;
    }

    @NotNull
    public final List<PropertySourceInfo> component2() {
        return this.sources;
    }

    @NotNull
    public final Properties component3() {
        return this.mergedProperties;
    }

    @NotNull
    public final Map<String, List<PropertyConflict>> component4() {
        return this.conflicts;
    }

    @NotNull
    public final PropertyAnalysis copy(@NotNull String fileName, @NotNull List<PropertySourceInfo> sources, @NotNull Properties mergedProperties, @NotNull Map<String, ? extends List<PropertyConflict>> conflicts) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)mergedProperties, (String)"mergedProperties");
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        return new PropertyAnalysis(fileName, sources, mergedProperties, conflicts);
    }

    public static /* synthetic */ PropertyAnalysis copy$default(PropertyAnalysis propertyAnalysis, String string, List list, Properties properties, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = propertyAnalysis.fileName;
        }
        if ((n & 2) != 0) {
            list = propertyAnalysis.sources;
        }
        if ((n & 4) != 0) {
            properties = propertyAnalysis.mergedProperties;
        }
        if ((n & 8) != 0) {
            map = propertyAnalysis.conflicts;
        }
        return propertyAnalysis.copy(string, list, properties, map);
    }

    @NotNull
    public String toString() {
        return "PropertyAnalysis(fileName=" + this.fileName + ", sources=" + this.sources + ", mergedProperties=" + this.mergedProperties + ", conflicts=" + this.conflicts + ")";
    }

    public int hashCode() {
        int result = this.fileName.hashCode();
        result = result * 31 + ((Object)this.sources).hashCode();
        result = result * 31 + this.mergedProperties.hashCode();
        result = result * 31 + ((Object)this.conflicts).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PropertyAnalysis)) {
            return false;
        }
        PropertyAnalysis propertyAnalysis = (PropertyAnalysis)other;
        if (!Intrinsics.areEqual((Object)this.fileName, (Object)propertyAnalysis.fileName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.sources, propertyAnalysis.sources)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.mergedProperties, (Object)propertyAnalysis.mergedProperties)) {
            return false;
        }
        return Intrinsics.areEqual(this.conflicts, propertyAnalysis.conflicts);
    }
}

