/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.starter.shell;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="embabel.agent.shell")
public class AgentShellStarterProperties {
    @NotNull
    @Pattern(regexp="none|servlet|reactive", message="Web application type must be 'none', 'servlet', or 'reactive'")
    private String webApplicationType = "none";
    @Valid
    @NotNull
    private final Command command = new Command();
    @Valid
    @NotNull
    private final Interactive interactive = new Interactive();

    public String getWebApplicationType() {
        return this.webApplicationType;
    }

    public void setWebApplicationType(String webApplicationType) {
        this.webApplicationType = webApplicationType;
    }

    public Command getCommand() {
        return this.command;
    }

    public Interactive getInteractive() {
        return this.interactive;
    }

    public static class Command {
        private boolean exitEnabled = false;
        private boolean quitEnabled = false;

        public boolean isExitEnabled() {
            return this.exitEnabled;
        }

        public void setExitEnabled(boolean exitEnabled) {
            this.exitEnabled = exitEnabled;
        }

        public boolean isQuitEnabled() {
            return this.quitEnabled;
        }

        public void setQuitEnabled(boolean quitEnabled) {
            this.quitEnabled = quitEnabled;
        }
    }

    public static class Interactive {
        private boolean enabled = true;
        private boolean historyEnabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isHistoryEnabled() {
            return this.historyEnabled;
        }

        public void setHistoryEnabled(boolean historyEnabled) {
            this.historyEnabled = historyEnabled;
        }
    }
}

