/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.shell;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import com.embabel.agent.api.channel.ContentOutputChannelEvent;
import com.embabel.agent.api.channel.LoggingOutputChannelEvent;
import com.embabel.agent.api.channel.MessageOutputChannelEvent;
import com.embabel.agent.api.channel.OutputChannel;
import com.embabel.agent.api.channel.OutputChannelEvent;
import com.embabel.agent.api.channel.ProgressOutputChannelEvent;
import com.embabel.agent.api.common.autonomy.GoalChoiceApprovalRequest;
import com.embabel.agent.api.common.autonomy.GoalChoiceApprovalResponse;
import com.embabel.agent.api.common.autonomy.GoalChoiceApproved;
import com.embabel.agent.api.common.autonomy.GoalChoiceApprover;
import com.embabel.agent.api.common.autonomy.GoalChoiceNotApproved;
import com.embabel.agent.core.AgentPlatform;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.hitl.Awaitable;
import com.embabel.agent.core.hitl.AwaitableResponse;
import com.embabel.agent.core.hitl.ConfirmationRequest;
import com.embabel.agent.core.hitl.ConfirmationResponse;
import com.embabel.agent.core.hitl.FormBindingRequest;
import com.embabel.agent.core.hitl.FormResponse;
import com.embabel.agent.shell.ShellCommands;
import com.embabel.agent.shell.config.ShellProperties;
import com.embabel.agent.spi.logging.ColorPalette;
import com.embabel.agent.spi.logging.DefaultColorPalette;
import com.embabel.chat.AssistantMessage;
import com.embabel.chat.ChatSession;
import com.embabel.chat.Message;
import com.embabel.chat.UserMessage;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.common.util.AnsiBuilderKt;
import com.embabel.ux.form.Button;
import com.embabel.ux.form.Control;
import com.embabel.ux.form.Form;
import com.embabel.ux.form.FormSubmission;
import com.embabel.ux.form.TextField;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.text.WordUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u00013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u0002H\t0\u000bH\u0012\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\u0014\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0012J\u0016\u0010#\u001a\u0004\u0018\u00010$2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&H\u0012J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000f002\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/embabel/agent/shell/TerminalServices;", "Lcom/embabel/agent/api/common/autonomy/GoalChoiceApprover;", "terminal", "Lorg/jline/terminal/Terminal;", "shellProperties", "Lcom/embabel/agent/shell/config/ShellProperties;", "<init>", "(Lorg/jline/terminal/Terminal;Lcom/embabel/agent/shell/config/ShellProperties;)V", "doWithLineReader", "T", "callback", "Lkotlin/Function1;", "Lorg/jline/reader/LineReader;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "print", "", "what", "", "chat", "chatSession", "Lcom/embabel/chat/ChatSession;", "welcome", "colorPalette", "Lcom/embabel/agent/spi/logging/ColorPalette;", "handleAwaitable", "Lcom/embabel/agent/core/hitl/AwaitableResponse;", "awaitable", "Lcom/embabel/agent/core/hitl/Awaitable;", "confirm", "", "message", "confirmationResponseFromUserInput", "Lcom/embabel/agent/core/hitl/ConfirmationResponse;", "confirmationRequest", "Lcom/embabel/agent/core/hitl/ConfirmationRequest;", "formBindingResponseFromUserInput", "Lcom/embabel/agent/core/hitl/FormResponse;", "formBindingRequest", "Lcom/embabel/agent/core/hitl/FormBindingRequest;", "approve", "Lcom/embabel/agent/api/common/autonomy/GoalChoiceApprovalResponse;", "goalChoiceApprovalRequest", "Lcom/embabel/agent/api/common/autonomy/GoalChoiceApprovalRequest;", "outputChannel", "Lcom/embabel/agent/api/channel/OutputChannel;", "agentPlatform", "Lcom/embabel/agent/core/AgentPlatform;", "redirectLoggingToFile", "Lkotlin/Function0;", "filename", "dir", "TerminalOutputChannel", "embabel-agent-shell"})
@SourceDebugExtension(value={"SMAP\nTerminalServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalServices.kt\ncom/embabel/agent/shell/TerminalServices\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,349:1\n1#2:350\n27#3:351\n27#3:352\n27#3:355\n1863#4,2:353\n*S KotlinDebug\n*F\n+ 1 TerminalServices.kt\ncom/embabel/agent/shell/TerminalServices\n*L\n331#1:351\n149#1:352\n344#1:355\n340#1:353,2\n*E\n"})
public class TerminalServices
implements GoalChoiceApprover {
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final ShellProperties shellProperties;

    public TerminalServices(@NotNull Terminal terminal, @NotNull ShellProperties shellProperties) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)shellProperties, (String)"shellProperties");
        this.terminal = terminal;
        this.shellProperties = shellProperties;
    }

    private <T> T doWithLineReader(Function1<? super LineReader, ? extends T> callback) {
        LineReader lineReader = LineReaderBuilder.builder().terminal(this.terminal).build();
        Intrinsics.checkNotNull((Object)lineReader);
        return (T)callback.invoke((Object)lineReader);
    }

    public void print(@NotNull String what) {
        Intrinsics.checkNotNullParameter((Object)what, (String)"what");
        this.doWithLineReader(arg_0 -> TerminalServices.print$lambda$0(what, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public String chat(@NotNull ChatSession chatSession, @Nullable String welcome, @NotNull ColorPalette colorPalette) {
        String userInput;
        Object object;
        LineReader lineReader;
        LineReader lineReader2;
        block4: {
            block3: {
                void it;
                Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
                Intrinsics.checkNotNullParameter((Object)colorPalette, (String)"colorPalette");
                lineReader = lineReader2 = LineReaderBuilder.builder().terminal(this.terminal).build();
                object = welcome;
                if (object == null) break block3;
                String string = object;
                LineReader lineReader3 = lineReader;
                boolean bl = false;
                String string2 = (String)it + "\n";
                lineReader = lineReader3;
                object = string2;
                if (string2 != null) break block4;
            }
            object = "";
        }
        lineReader.printAbove((String)object + AnsiBuilderKt.color((String)StringsKt.trimIndent((String)("\n            Chat session " + chatSession.getConversation().getId() + " started. Type 'exit' to end the session.\n            Type /help for available commands.\n            ")), (int)colorPalette.getHighlight()));
        while (!StringsKt.equals((String)(userInput = lineReader2.readLine(AnsiBuilderKt.color((String)"You: ", (int)colorPalette.getHighlight()))), (String)"exit", (boolean)true)) {
            Intrinsics.checkNotNull((Object)userInput);
            UserMessage userMessage = new UserMessage(userInput, null, null, 6, null);
            chatSession.onUserMessage(userMessage);
        }
        return "Conversation finished";
    }

    public static /* synthetic */ String chat$default(TerminalServices terminalServices, ChatSession chatSession, String string, ColorPalette colorPalette, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: chat");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            colorPalette = (ColorPalette)new DefaultColorPalette(0, 0, 3, null);
        }
        return terminalServices.chat(chatSession, string, colorPalette);
    }

    @Nullable
    public AwaitableResponse handleAwaitable(@NotNull Awaitable<?, ?> awaitable) {
        AwaitableResponse awaitableResponse;
        Intrinsics.checkNotNullParameter(awaitable, (String)"awaitable");
        Awaitable<?, ?> awaitable2 = awaitable;
        if (awaitable2 instanceof ConfirmationRequest) {
            awaitableResponse = (AwaitableResponse)this.confirmationResponseFromUserInput((ConfirmationRequest)awaitable);
        } else if (awaitable2 instanceof FormBindingRequest) {
            awaitableResponse = (AwaitableResponse)this.formBindingResponseFromUserInput((FormBindingRequest)awaitable);
        } else {
            String string = "Unhandled awaitable: " + HasInfoString.infoString$default((HasInfoString)((HasInfoString)awaitable), null, (int)0, (int)3, null);
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        AwaitableResponse awaitableResponse2 = awaitableResponse;
        return awaitableResponse2;
    }

    public boolean confirm(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return (Boolean)this.doWithLineReader(arg_0 -> TerminalServices.confirm$lambda$2(message, arg_0));
    }

    private ConfirmationResponse confirmationResponseFromUserInput(ConfirmationRequest<?> confirmationRequest) {
        boolean confirmed = this.confirm(confirmationRequest.getMessage());
        return new ConfirmationResponse(null, confirmationRequest.getId(), confirmed, false, null, 25, null);
    }

    private FormResponse formBindingResponseFromUserInput(FormBindingRequest<?> formBindingRequest) {
        Form form = (Form)formBindingRequest.getPayload();
        Map values = new LinkedHashMap();
        return (FormResponse)this.doWithLineReader(arg_0 -> TerminalServices.formBindingResponseFromUserInput$lambda$3(form, values, formBindingRequest, arg_0));
    }

    @NotNull
    public GoalChoiceApprovalResponse approve(@NotNull GoalChoiceApprovalRequest goalChoiceApprovalRequest) {
        Intrinsics.checkNotNullParameter((Object)goalChoiceApprovalRequest, (String)"goalChoiceApprovalRequest");
        boolean approved = this.confirm("Do you approve this goal: " + goalChoiceApprovalRequest.getGoal().getDescription() + "?");
        return approved ? (GoalChoiceApprovalResponse)new GoalChoiceApproved(goalChoiceApprovalRequest) : (GoalChoiceApprovalResponse)new GoalChoiceNotApproved(goalChoiceApprovalRequest, "User said now");
    }

    @NotNull
    public OutputChannel outputChannel(@NotNull AgentPlatform agentPlatform) {
        Intrinsics.checkNotNullParameter((Object)agentPlatform, (String)"agentPlatform");
        return new TerminalOutputChannel(this, agentPlatform, null, 2, null);
    }

    @NotNull
    public Function0<Unit> redirectLoggingToFile(@NotNull String filename, @NotNull String dir) {
        PatternLayoutEncoder patternLayoutEncoder;
        FileAppender fileAppender;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        Intrinsics.checkNotNull((Object)iLoggerFactory, (String)"null cannot be cast to non-null type ch.qos.logback.classic.LoggerContext");
        LoggerContext loggerContext = (LoggerContext)iLoggerFactory;
        ch.qos.logback.classic.Logger logger = loggerContext.getLogger("ROOT");
        Intrinsics.checkNotNull((Object)logger, (String)"null cannot be cast to non-null type ch.qos.logback.classic.Logger");
        ch.qos.logback.classic.Logger rootLogger = logger;
        Map originalAppenders = new LinkedHashMap();
        Iterator appenderIterator = rootLogger.iteratorForAppenders();
        while (appenderIterator.hasNext()) {
            Appender appender = (Appender)appenderIterator.next();
            originalAppenders.put(appender.getName(), appender);
            rootLogger.detachAppender(appender);
        }
        String[] stringArray = new String[]{"logs"};
        Path logsDir = Paths.get(dir, stringArray);
        Files.createDirectories(logsDir, new FileAttribute[0]);
        Path logFile = logsDir.resolve(filename + ".log");
        System.out.println((Object)("Redirecting logging during chat session to " + logFile));
        FileAppender $this$redirectLoggingToFile_u24lambda_u245 = fileAppender = new FileAppender();
        boolean bl = false;
        $this$redirectLoggingToFile_u24lambda_u245.setContext((Context)loggerContext);
        $this$redirectLoggingToFile_u24lambda_u245.setName(filename);
        $this$redirectLoggingToFile_u24lambda_u245.setFile(((Object)logFile).toString());
        PatternLayoutEncoder $this$redirectLoggingToFile_u24lambda_u245_u24lambda_u244 = patternLayoutEncoder = new PatternLayoutEncoder();
        boolean bl2 = false;
        $this$redirectLoggingToFile_u24lambda_u245_u24lambda_u244.setContext((Context)loggerContext);
        $this$redirectLoggingToFile_u24lambda_u245_u24lambda_u244.setPattern("%d{HH:mm:ss.SSS} [%t] %-5level %logger{36} - %msg%n");
        $this$redirectLoggingToFile_u24lambda_u245_u24lambda_u244.start();
        PatternLayoutEncoder encoder = patternLayoutEncoder;
        $this$redirectLoggingToFile_u24lambda_u245.setEncoder((Encoder)encoder);
        $this$redirectLoggingToFile_u24lambda_u245.start();
        FileAppender fileAppender2 = fileAppender;
        rootLogger.addAppender((Appender)fileAppender2);
        boolean $i$f$loggerFor = false;
        Logger logger2 = LoggerFactory.getLogger(TerminalServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        logger2.info("Logs redirected to: " + logFile);
        return () -> TerminalServices.redirectLoggingToFile$lambda$7(rootLogger, fileAppender2, originalAppenders, logFile);
    }

    @JvmOverloads
    @NotNull
    public final String chat(@NotNull ChatSession chatSession, @Nullable String welcome) {
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        return TerminalServices.chat$default(this, chatSession, welcome, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final String chat(@NotNull ChatSession chatSession) {
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        return TerminalServices.chat$default(this, chatSession, null, null, 6, null);
    }

    private static final Unit print$lambda$0(String $what, LineReader it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.printAbove($what);
        return Unit.INSTANCE;
    }

    private static final boolean confirm$lambda$2(String $message, LineReader it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.equals((String)it.readLine(AnsiBuilderKt.color((String)($message + " (y/n): "), (String)"33")), (String)"y", (boolean)true);
    }

    private static final FormResponse formBindingResponseFromUserInput$lambda$3(Form $form, Map $values, FormBindingRequest $formBindingRequest, LineReader lineReader) {
        Intrinsics.checkNotNullParameter((Object)lineReader, (String)"lineReader");
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(ShellCommands.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.info("Form: " + HasInfoString.infoString$default((HasInfoString)((HasInfoString)$form), null, (int)0, (int)3, null));
        lineReader.printAbove($form.getTitle());
        for (Control control : $form.getControls()) {
            Control control2 = control;
            if (control2 instanceof TextField) {
                String input = null;
                boolean isValid = false;
                while (!isValid) {
                    String prompt = AnsiBuilderKt.color((String)(((TextField)control).getLabel() + (((TextField)control).getRequired() ? " *" : "") + ": "), (String)"33");
                    input = lineReader.readLine(prompt);
                    if (((TextField)control).getRequired() && StringsKt.isBlank((CharSequence)input)) {
                        lineReader.printAbove("This field is required.");
                        continue;
                    }
                    if (((TextField)control).getMaxLength() != null) {
                        int n = input.length();
                        Integer n2 = ((TextField)control).getMaxLength();
                        Intrinsics.checkNotNull((Object)n2);
                        if (n > n2) {
                            lineReader.printAbove("Input exceeds maximum length of " + ((TextField)control).getMaxLength() + " characters.");
                            continue;
                        }
                    }
                    if (((TextField)control).getValidationPattern() != null && !StringsKt.isBlank((CharSequence)input)) {
                        String string = ((TextField)control).getValidationPattern();
                        Intrinsics.checkNotNull((Object)string);
                        Regex regex = new Regex(string);
                        if (!regex.matches((CharSequence)input)) {
                            String string2 = ((TextField)control).getValidationMessage();
                            if (string2 == null) {
                                string2 = "Input doesn't match required format.";
                            }
                            lineReader.printAbove(string2);
                            continue;
                        }
                    }
                    $values.put(((TextField)control).getId(), input);
                    isValid = true;
                }
                continue;
            }
            if (control2 instanceof Button) continue;
            lineReader.printAbove("Unsupported control type: " + control.getType());
        }
        boolean confirmSubmit = StringsKt.equals((String)lineReader.readLine(AnsiBuilderKt.color((String)"Submit form? (y/n): ", (String)"33")), (String)"y", (boolean)true);
        return !confirmSubmit ? null : new FormResponse(null, $formBindingRequest.getId(), new FormSubmission($form.getId(), $values, null, null, 12, null), false, null, 25, null);
    }

    private static final Unit redirectLoggingToFile$lambda$7(ch.qos.logback.classic.Logger $rootLogger, FileAppender $fileAppender, Map $originalAppenders, Path $logFile) {
        $rootLogger.detachAppender((Appender)$fileAppender);
        $fileAppender.stop();
        Iterable $this$forEach$iv = $originalAppenders.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Appender appender = (Appender)element$iv;
            boolean bl = false;
            $rootLogger.addAppender(appender);
        }
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(TerminalServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.info("Logging to console restored. Logs are available at: " + $logFile);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/embabel/agent/shell/TerminalServices$TerminalOutputChannel;", "Lcom/embabel/agent/api/channel/OutputChannel;", "agentPlatform", "Lcom/embabel/agent/core/AgentPlatform;", "colorPalette", "Lcom/embabel/agent/spi/logging/ColorPalette;", "<init>", "(Lcom/embabel/agent/shell/TerminalServices;Lcom/embabel/agent/core/AgentPlatform;Lcom/embabel/agent/spi/logging/ColorPalette;)V", "send", "", "event", "Lcom/embabel/agent/api/channel/OutputChannelEvent;", "embabel-agent-shell"})
    private final class TerminalOutputChannel
    implements OutputChannel {
        @NotNull
        private final AgentPlatform agentPlatform;
        @NotNull
        private final ColorPalette colorPalette;
        final /* synthetic */ TerminalServices this$0;

        public TerminalOutputChannel(@NotNull TerminalServices this$0, @NotNull AgentPlatform agentPlatform, ColorPalette colorPalette) {
            Intrinsics.checkNotNullParameter((Object)agentPlatform, (String)"agentPlatform");
            Intrinsics.checkNotNullParameter((Object)colorPalette, (String)"colorPalette");
            this.this$0 = this$0;
            this.agentPlatform = agentPlatform;
            this.colorPalette = colorPalette;
        }

        public /* synthetic */ TerminalOutputChannel(TerminalServices terminalServices, AgentPlatform agentPlatform, ColorPalette colorPalette, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                colorPalette = (ColorPalette)new DefaultColorPalette(0, 0, 3, null);
            }
            this(terminalServices, agentPlatform, colorPalette);
        }

        public void send(@NotNull OutputChannelEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            OutputChannelEvent outputChannelEvent = event;
            if (outputChannelEvent instanceof MessageOutputChannelEvent) {
                String formattedResponse = WordUtils.wrap((String)(((MessageOutputChannelEvent)event).getMessage().getSender() + ": " + AnsiBuilderKt.color((String)((MessageOutputChannelEvent)event).getMessage().getContent(), (int)this.colorPalette.getColor2())), (int)this.this$0.shellProperties.getLineLength());
                System.out.println((Object)formattedResponse);
                AgentProcess agentProcess = this.agentPlatform.getAgentProcess(((MessageOutputChannelEvent)event).getProcessId());
                if (agentProcess == null) {
                    throw new IllegalStateException("Process not found: " + ((MessageOutputChannelEvent)event).getProcessId());
                }
                AgentProcess agentProcess2 = agentProcess;
                Message message = ((MessageOutputChannelEvent)event).getMessage();
                AssistantMessage assistantMessage = message instanceof AssistantMessage ? (AssistantMessage)message : null;
                if (assistantMessage != null && (assistantMessage = assistantMessage.getAwaitable()) != null) {
                    AssistantMessage assistantMessage2 = assistantMessage;
                    TerminalServices terminalServices = this.this$0;
                    AssistantMessage awaitable = assistantMessage2;
                    boolean bl = false;
                    AwaitableResponse awaitableResponse = terminalServices.handleAwaitable((Awaitable<?, ?>)awaitable);
                    if (awaitableResponse == null) {
                        throw new NotImplementedError(null, 1, null);
                    }
                    awaitable.onResponse(awaitableResponse, agentProcess2);
                    agentProcess2.run();
                }
            } else if (outputChannelEvent instanceof ContentOutputChannelEvent) {
                System.out.println((Object)("Content event: " + ((ContentOutputChannelEvent)event).getContent()));
            } else if (outputChannelEvent instanceof ProgressOutputChannelEvent) {
                System.out.println((Object)("\u25b6 " + ((ProgressOutputChannelEvent)event).getMessage()));
            } else if (outputChannelEvent instanceof LoggingOutputChannelEvent) {
                System.out.println((Object)("\ud83e\udeb5 " + ((LoggingOutputChannelEvent)event).getMessage()));
            } else {
                System.out.println((Object)event.toString());
            }
        }
    }
}

