/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.shell;

import com.embabel.agent.api.common.ToolsStats;
import com.embabel.agent.api.common.autonomy.AgentProcessExecution;
import com.embabel.agent.api.common.autonomy.Autonomy;
import com.embabel.agent.api.common.autonomy.GoalChoiceApprover;
import com.embabel.agent.api.common.autonomy.GoalNotApproved;
import com.embabel.agent.api.common.autonomy.GoalSelectionOptions;
import com.embabel.agent.api.common.autonomy.NoAgentFound;
import com.embabel.agent.api.common.autonomy.NoGoalFound;
import com.embabel.agent.api.common.autonomy.ProcessExecutionStuckException;
import com.embabel.agent.api.common.autonomy.ProcessExecutionTerminatedException;
import com.embabel.agent.api.common.autonomy.ProcessWaitingException;
import com.embabel.agent.channel.OutputChannel;
import com.embabel.agent.core.Action;
import com.embabel.agent.core.ActionInvocation;
import com.embabel.agent.core.Agent;
import com.embabel.agent.core.AgentPlatform;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.AgentScope;
import com.embabel.agent.core.Blackboard;
import com.embabel.agent.core.Condition;
import com.embabel.agent.core.Delay;
import com.embabel.agent.core.EarlyTerminationPolicy;
import com.embabel.agent.core.Goal;
import com.embabel.agent.core.ProcessControl;
import com.embabel.agent.core.ProcessOptions;
import com.embabel.agent.core.ToolGroup;
import com.embabel.agent.core.ToolGroupMetadata;
import com.embabel.agent.core.ToolGroupRequirement;
import com.embabel.agent.core.ToolGroupResolution;
import com.embabel.agent.core.Verbosity;
import com.embabel.agent.core.hitl.AwaitableResponse;
import com.embabel.agent.domain.io.UserInput;
import com.embabel.agent.event.logging.LoggingPersonality;
import com.embabel.agent.event.logging.personality.ColorPalette;
import com.embabel.agent.identity.User;
import com.embabel.agent.prompt.persona.Persona;
import com.embabel.agent.shell.FormatProcessOutputKt;
import com.embabel.agent.shell.TerminalServices;
import com.embabel.agent.shell.config.ShellProperties;
import com.embabel.agent.spi.Ranking;
import com.embabel.agent.spi.ToolGroupResolver;
import com.embabel.chat.ChatSession;
import com.embabel.chat.Chatbot;
import com.embabel.chat.agent.AgentProcessChatbot;
import com.embabel.chat.agent.DefaultChatAgentBuilder;
import com.embabel.chat.agent.PersonasKt;
import com.embabel.common.ai.model.LlmOptions;
import com.embabel.common.ai.model.ModelProvider;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.common.util.AnsiBuilderKt;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\n\b\u0003\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\b\u0010'\u001a\u00020(H\u0017J\b\u0010)\u001a\u00020(H\u0017J\b\u0010*\u001a\u00020(H\u0017J\b\u0010+\u001a\u00020\u0017H\u0012J\b\u0010,\u001a\u00020(H\u0017J\b\u0010-\u001a\u00020(H\u0017J\b\u0010.\u001a\u00020(H\u0017J\b\u0010/\u001a\u00020(H\u0017J\b\u00100\u001a\u00020(H\u0017J\u0012\u00101\u001a\u00020(2\b\b\u0001\u00102\u001a\u00020(H\u0017J\b\u00103\u001a\u00020(H\u0017J\b\u0010!\u001a\u00020(H\u0017J\b\u00104\u001a\u00020(H\u0017J\b\u00105\u001a\u00020(H\u0017J\b\u00106\u001a\u00020(H\u0017J\b\u00107\u001a\u00020(H\u0017Jb\u00108\u001a\u00020(2\b\b\u0003\u00109\u001a\u00020$2\b\b\u0003\u0010:\u001a\u00020$2\b\b\u0001\u0010;\u001a\u00020$2\b\b\u0003\u0010<\u001a\u00020$2\b\b\u0003\u0010=\u001a\u00020$2\b\b\u0003\u0010>\u001a\u00020$2\b\b\u0003\u0010?\u001a\u00020$2\b\b\u0003\u0010@\u001a\u00020$2\b\b\u0003\u0010A\u001a\u00020$H\u0017Jb\u0010B\u001a\u00020(2\b\b\u0001\u00102\u001a\u00020(2\b\b\u0003\u00109\u001a\u00020$2\b\b\u0001\u0010;\u001a\u00020$2\b\b\u0003\u0010<\u001a\u00020$2\b\b\u0003\u0010=\u001a\u00020$2\b\b\u0003\u0010>\u001a\u00020$2\b\b\u0003\u0010?\u001a\u00020$2\b\b\u0003\u0010@\u001a\u00020$2\b\b\u0003\u0010A\u001a\u00020$H\u0017J\b\u0010C\u001a\u00020(H\u0017J\u0018\u0010D\u001a\u00020(2\u0006\u0010E\u001a\u00020&2\u0006\u00102\u001a\u00020(H\u0012J\u0010\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020 H\u0012J&\u0010I\u001a\u00020(2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\u00012\f\u0010M\u001a\b\u0012\u0004\u0012\u00020O0NH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0092\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/embabel/agent/shell/ShellCommands;", "", "autonomy", "Lcom/embabel/agent/api/common/autonomy/Autonomy;", "modelProvider", "Lcom/embabel/common/ai/model/ModelProvider;", "terminalServices", "Lcom/embabel/agent/shell/TerminalServices;", "environment", "Lorg/springframework/core/env/ConfigurableEnvironment;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "colorPalette", "Lcom/embabel/agent/event/logging/personality/ColorPalette;", "loggingPersonality", "Lcom/embabel/agent/event/logging/LoggingPersonality;", "toolsStats", "Lcom/embabel/agent/api/common/ToolsStats;", "context", "Lorg/springframework/context/ConfigurableApplicationContext;", "shellProperties", "Lcom/embabel/agent/shell/config/ShellProperties;", "chatbot", "Lcom/embabel/chat/Chatbot;", "<init>", "(Lcom/embabel/agent/api/common/autonomy/Autonomy;Lcom/embabel/common/ai/model/ModelProvider;Lcom/embabel/agent/shell/TerminalServices;Lorg/springframework/core/env/ConfigurableEnvironment;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/embabel/agent/event/logging/personality/ColorPalette;Lcom/embabel/agent/event/logging/LoggingPersonality;Lcom/embabel/agent/api/common/ToolsStats;Lorg/springframework/context/ConfigurableApplicationContext;Lcom/embabel/agent/shell/config/ShellProperties;Lcom/embabel/chat/Chatbot;)V", "logger", "Lorg/slf4j/Logger;", "agentPlatform", "Lcom/embabel/agent/core/AgentPlatform;", "agentProcesses", "", "Lcom/embabel/agent/core/AgentProcess;", "blackboard", "Lcom/embabel/agent/core/Blackboard;", "openMode", "", "defaultProcessOptions", "Lcom/embabel/agent/core/ProcessOptions;", "clear", "", "runs", "profiles", "createDefaultChatbot", "chat", "agents", "actions", "conditions", "goals", "chooseGoal", "intent", "platform", "tools", "toolStats", "models", "showOptions", "setOptions", "open", "test", "showPrompts", "showLlmResponses", "debug", "state", "toolDelay", "operationDelay", "showPlanning", "execute", "exit", "executeIntent", "processOptions", "recordAgentProcess", "", "agentProcess", "runProcess", "verbosity", "Lcom/embabel/agent/core/Verbosity;", "basis", "run", "Lkotlin/Function0;", "Lcom/embabel/agent/api/common/autonomy/AgentProcessExecution;", "embabel-agent-shell"})
@SourceDebugExtension(value={"SMAP\nShellCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommands.kt\ncom/embabel/agent/shell/ShellCommands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,469:1\n1557#2:470\n1628#2,2:471\n1557#2:473\n1628#2,3:474\n1630#2:477\n1557#2:478\n1628#2,3:479\n1611#2,9:482\n1863#2:491\n1864#2:493\n1620#2:494\n1053#2:495\n1#3:492\n1#3:496\n*S KotlinDebug\n*F\n+ 1 ShellCommands.kt\ncom/embabel/agent/shell/ShellCommands\n*L\n96#1:470\n96#1:471,2\n97#1:473\n97#1:474,3\n96#1:477\n231#1:478\n231#1:479,3\n232#1:482,9\n232#1:491\n232#1:493\n232#1:494\n233#1:495\n232#1:492\n*E\n"})
public class ShellCommands {
    @NotNull
    private final Autonomy autonomy;
    @NotNull
    private final ModelProvider modelProvider;
    @NotNull
    private final TerminalServices terminalServices;
    @NotNull
    private final ConfigurableEnvironment environment;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final ColorPalette colorPalette;
    @NotNull
    private final ToolsStats toolsStats;
    @NotNull
    private final ConfigurableApplicationContext context;
    @NotNull
    private final ShellProperties shellProperties;
    @Nullable
    private final Chatbot chatbot;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AgentPlatform agentPlatform;
    @NotNull
    private final List<AgentProcess> agentProcesses;
    @Nullable
    private Blackboard blackboard;
    private boolean openMode;
    @NotNull
    private ProcessOptions defaultProcessOptions;

    public ShellCommands(@NotNull Autonomy autonomy, @NotNull ModelProvider modelProvider, @NotNull TerminalServices terminalServices, @NotNull ConfigurableEnvironment environment, @NotNull ObjectMapper objectMapper, @NotNull ColorPalette colorPalette, @NotNull LoggingPersonality loggingPersonality, @NotNull ToolsStats toolsStats, @NotNull ConfigurableApplicationContext context, @NotNull ShellProperties shellProperties, @Autowired(required=false) @Nullable Chatbot chatbot) {
        Intrinsics.checkNotNullParameter((Object)autonomy, (String)"autonomy");
        Intrinsics.checkNotNullParameter((Object)modelProvider, (String)"modelProvider");
        Intrinsics.checkNotNullParameter((Object)terminalServices, (String)"terminalServices");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)colorPalette, (String)"colorPalette");
        Intrinsics.checkNotNullParameter((Object)loggingPersonality, (String)"loggingPersonality");
        Intrinsics.checkNotNullParameter((Object)toolsStats, (String)"toolsStats");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)shellProperties, (String)"shellProperties");
        this.autonomy = autonomy;
        this.modelProvider = modelProvider;
        this.terminalServices = terminalServices;
        this.environment = environment;
        this.objectMapper = objectMapper;
        this.colorPalette = colorPalette;
        this.toolsStats = toolsStats;
        this.context = context;
        this.shellProperties = shellProperties;
        this.chatbot = chatbot;
        this.logger = loggingPersonality.getLogger();
        this.agentPlatform = this.autonomy.getAgentPlatform();
        this.agentProcesses = new ArrayList();
        this.defaultProcessOptions = new ProcessOptions(null, null, null, new Verbosity(false, false, false, true), null, null, false, null, null, 503, null);
    }

    public /* synthetic */ ShellCommands(Autonomy autonomy, ModelProvider modelProvider, TerminalServices terminalServices, ConfigurableEnvironment configurableEnvironment, ObjectMapper objectMapper, ColorPalette colorPalette, LoggingPersonality loggingPersonality, ToolsStats toolsStats, ConfigurableApplicationContext configurableApplicationContext, ShellProperties shellProperties, Chatbot chatbot, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x200) != 0) {
            shellProperties = new ShellProperties();
        }
        if ((n & 0x400) != 0) {
            chatbot = null;
        }
        this(autonomy, modelProvider, terminalServices, configurableEnvironment, objectMapper, colorPalette, loggingPersonality, toolsStats, configurableApplicationContext, shellProperties, chatbot);
    }

    @ShellMethod(value="Clear blackboard")
    @NotNull
    public String clear() {
        this.blackboard = null;
        return "Blackboard cleared";
    }

    /*
     * WARNING - void declaration
     */
    @ShellMethod(value="Show recent agent process runs. This is what actually happened, not just what was planned.")
    @NotNull
    public String runs() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.agentProcesses;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void it;
            AgentProcess agentProcess = (AgentProcess)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = it.getAgent().getGoals();
            String string = it.getId();
            boolean $i$f$map2 = false;
            void var14_13 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void g;
                Goal goal = (Goal)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(g.getName());
            }
            collection.add("[" + string + "] Goal: " + (List)destination$iv$iv2 + "; usage - " + it.costInfoString(false) + "\n\t\t" + CollectionsKt.joinToString$default((Iterable)it.getHistory(), (CharSequence)"\n\t\t", null, null, (int)0, null, ShellCommands::runs$lambda$2$lambda$1, (int)30, null));
        }
        List plans = (List)destination$iv$iv;
        return "Recent runs:\n\t" + CollectionsKt.joinToString$default((Iterable)plans, (CharSequence)"\n\t", null, null, (int)0, null, null, (int)62, null);
    }

    @ShellMethod(value="List all active Spring profiles")
    @NotNull
    public String profiles() {
        Object[] objectArray = this.environment.getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getActiveProfiles(...)");
        Object[] profiles = objectArray;
        return "Active profiles: " + ArraysKt.joinToString$default((Object[])profiles, null, null, null, (int)0, null, null, (int)63, null);
    }

    private Chatbot createDefaultChatbot() {
        Persona persona = PersonasKt.getMARVIN();
        this.logger.info("Creating default chatbot with persona {}", (Object)persona.getName());
        Agent chatAgent = new DefaultChatAgentBuilder(this.autonomy, LlmOptions.Companion.withAutoLlm(), persona, null, null, 24, null).build();
        return (Chatbot)new AgentProcessChatbot(this.agentPlatform, arg_0 -> ShellCommands.createDefaultChatbot$lambda$3(chatAgent, arg_0), null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ShellMethod(value="Chat")
    @NotNull
    public String chat() {
        String string;
        if (this.shellProperties.getRedirectLogToFile()) {
            String string2;
            String string3 = System.getProperty("user.dir");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(...)");
            Function0<Unit> logRestorer = this.terminalServices.redirectLoggingToFile("chat-session", string3);
            try {
                string2 = ShellCommands.chat$runChat(this);
            }
            finally {
                logRestorer.invoke();
            }
            string = string2;
        } else {
            string = ShellCommands.chat$runChat(this);
        }
        return string;
    }

    @ShellMethod(value="List agents")
    @NotNull
    public String agents() {
        String detail = AnsiBuilderKt.bold((String)"Agents:") + "\n" + CollectionsKt.joinToString$default((Iterable)this.agentPlatform.agents(), (CharSequence)("\n" + StringsKt.repeat((CharSequence)"-", (int)this.shellProperties.getLineLength()) + "\n"), null, null, (int)0, null, ShellCommands::agents$lambda$4, (int)30, null);
        return detail + "\n\nTL;DR\n" + CollectionsKt.joinToString$default((Iterable)this.agentPlatform.agents(), (CharSequence)"\n", null, null, (int)0, null, ShellCommands::agents$lambda$5, (int)30, null);
    }

    @ShellMethod(value="List actions")
    @NotNull
    public String actions() {
        String detail = AnsiBuilderKt.bold((String)"Actions:") + "\n" + CollectionsKt.joinToString$default((Iterable)this.agentPlatform.getActions(), (CharSequence)"\n", null, null, (int)0, null, ShellCommands::actions$lambda$6, (int)30, null);
        return detail + "\n\nTL;DR\n" + CollectionsKt.joinToString$default((Iterable)this.agentPlatform.getActions(), (CharSequence)"\n", null, null, (int)0, null, ShellCommands::actions$lambda$7, (int)30, null);
    }

    @ShellMethod(value="List conditions")
    @NotNull
    public String conditions() {
        return AnsiBuilderKt.bold((String)"Conditions:") + "\n" + CollectionsKt.joinToString$default((Iterable)this.agentPlatform.getConditions(), (CharSequence)"\n", null, null, (int)0, null, ShellCommands::conditions$lambda$8, (int)30, null);
    }

    @ShellMethod(value="List goals")
    @NotNull
    public String goals() {
        return AnsiBuilderKt.bold((String)"Goals:") + "\n" + CollectionsKt.joinToString$default((Iterable)this.agentPlatform.getGoals(), (CharSequence)"\n", null, null, (int)0, null, ShellCommands::goals$lambda$9, (int)30, null);
    }

    @ShellMethod(value="Try to choose a goal for a given intent. Show all goal rankings")
    @NotNull
    public String chooseGoal(@ShellOption(help="what the agent system should do") @NotNull String intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            Autonomy autonomy = this.autonomy;
            AgentPlatform agentPlatform = this.agentPlatform;
            GoalChoiceApprover goalChoiceApprover = GoalChoiceApprover.Companion.approveWithScoreOver(0.8);
            GoalSelectionOptions goalSelectionOptions = new GoalSelectionOptions(null, null, false, 7, null);
            Autonomy.GoalSeeker goalSeeker = autonomy.createGoalSeeker(intent, goalChoiceApprover, (AgentScope)agentPlatform, goalSelectionOptions);
            String fmt = CollectionsKt.joinToString$default((Iterable)goalSeeker.getRankings().rankings(), (CharSequence)"\n", null, null, (int)0, null, ShellCommands::chooseGoal$lambda$10, (int)30, null);
            return AnsiBuilderKt.color((String)fmt, (int)this.colorPalette.getColor2()) + "\n" + HasInfoString.infoString$default((HasInfoString)((HasInfoString)goalSeeker.getAgent()), (Boolean)true, (int)0, (int)2, null);
        }
        catch (GoalNotApproved gna) {
            return "Goal not approved. Rankings were:\n" + HasInfoString.infoString$default((HasInfoString)((HasInfoString)gna.getGoalRankings()), (Boolean)true, (int)0, (int)2, null);
        }
        catch (NoGoalFound ngf) {
            return "No goal found. Rankings were:\n" + HasInfoString.infoString$default((HasInfoString)((HasInfoString)ngf.getGoalRankings()), (Boolean)true, (int)0, (int)2, null);
        }
    }

    @ShellMethod(value="Information about the AgentPlatform")
    @NotNull
    public String platform() {
        return "AgentPlatform: " + this.agentPlatform.getName();
    }

    @ShellMethod(value="Show last blackboard: The final state of a previous operation", key={"blackboard", "bb"})
    @NotNull
    public String blackboard() {
        String string;
        if (this.blackboard == null) {
            string = "No blackboard available. Please run a command first.";
        } else {
            Blackboard blackboard = this.blackboard;
            Intrinsics.checkNotNull((Object)blackboard);
            string = HasInfoString.infoString$default((HasInfoString)((HasInfoString)blackboard), (Boolean)true, (int)0, (int)2, null);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @ShellMethod(value="List available tool groups")
    @NotNull
    public String tools() {
        void $this$sortedBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Collection<ToolGroupResolution> collection;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        ToolGroupResolver tgr = this.agentPlatform.getToolGroupResolver();
        String string = "%s: %s: %d available tool groups: %s";
        Object[] objectArray = new Object[4];
        objectArray[0] = tgr.getClass().getName();
        objectArray[1] = tgr.getName();
        objectArray[2] = tgr.availableToolGroups().size();
        Iterable iterable = tgr.availableToolGroups();
        int n = 3;
        Object[] objectArray2 = objectArray;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (ToolGroupMetadata)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(tgr.resolveToolGroup(new ToolGroupRequirement(it.getRole())));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            ToolGroup it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            ToolGroupResolution it = (ToolGroupResolution)element$iv$iv;
            boolean bl2 = false;
            if (it.getResolvedToolGroup() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        collection = (List)destination$iv$iv;
        $this$mapNotNull$iv = collection;
        boolean $i$f$sortedBy = false;
        objectArray2[n] = "\n\t" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ToolGroup it = (ToolGroup)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getMetadata().getRole());
                it = (ToolGroup)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getMetadata().getRole())));
            }
        }), (CharSequence)"\n\t", null, null, (int)0, null, ShellCommands::tools$lambda$14, (int)30, null);
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @ShellMethod(value="Show tool stats")
    @NotNull
    public String toolStats() {
        return HasInfoString.infoString$default((HasInfoString)((HasInfoString)this.toolsStats), (Boolean)true, (int)0, (int)2, null);
    }

    @ShellMethod(value="List available models")
    @NotNull
    public String models() {
        return HasInfoString.infoString$default((HasInfoString)((HasInfoString)this.modelProvider), (Boolean)true, (int)0, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @ShellMethod(value="Show options")
    @NotNull
    public String showOptions() {
        Object object;
        String string;
        String string2;
        block3: {
            block2: {
                void it;
                String string3 = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)ProcessOptions.copy-ajcdVnI$default((ProcessOptions)this.defaultProcessOptions, null, null, null, null, null, null, (boolean)false, null, null, (int)507, null));
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"writeValueAsString(...)");
                string = "\"blackboard\" : null";
                object = this.blackboard;
                if (object == null) break block2;
                Blackboard blackboard = object;
                String string4 = string;
                String string5 = string2;
                boolean bl = false;
                String string6 = it.getObjects().size() + " entries";
                string2 = string5;
                string = string4;
                String string7 = string6;
                object = string7;
                if (string7 != null) break block3;
            }
            object = "empty";
        }
        return AnsiBuilderKt.color((String)StringsKt.replace$default((String)string2, (String)string, (String)StringsKt.trimIndent((String)("\n            \"blackboard\" : <" + (String)object + ">\n        ")), (boolean)false, (int)4, null), (int)this.colorPalette.getColor2());
    }

    @ShellMethod(value="Set options")
    @NotNull
    public String setOptions(@ShellOption(value={"-o", "--open"}, help="run in open mode, choosing a goal and using all actions that can help achieve it") boolean open, @ShellOption(value={"-t", "--test"}, help="run in help mode") boolean test, @ShellOption(value={"-p", "--showPrompts"}, help="show prompts to LLMs") boolean showPrompts, @ShellOption(value={"-r", "--showResponses"}, help="show LLM responses") boolean showLlmResponses, @ShellOption(value={"-d", "--debug"}, help="show debug info") boolean debug, @ShellOption(value={"-s", "--state"}, help="Use existing blackboard") boolean state, @ShellOption(value={"-td", "--toolDelay"}, help="Tool delay") boolean toolDelay, @ShellOption(value={"-od", "--operationDelay"}, help="Operation delay") boolean operationDelay, @ShellOption(value={"-s", "--showPlanning"}, defaultValue="true", help="show detailed planning info") boolean showPlanning) {
        this.openMode = open;
        Verbosity verbosity = new Verbosity(showPrompts, showLlmResponses, debug, showPlanning);
        EarlyTerminationPolicy earlyTerminationPolicy = EarlyTerminationPolicy.Companion.maxActions(40);
        Delay delay = toolDelay ? Delay.LONG : Delay.NONE;
        Delay delay2 = operationDelay ? Delay.MEDIUM : Delay.NONE;
        this.defaultProcessOptions = new ProcessOptions(null, null, state ? this.blackboard : null, verbosity, null, new ProcessControl(delay, delay2, earlyTerminationPolicy), false, null, null, 467, null);
        return AnsiBuilderKt.color((String)("Options updated:\nOpen mode:" + this.openMode + "\n" + this.showOptions()), (int)this.colorPalette.getColor2());
    }

    public static /* synthetic */ String setOptions$default(ShellCommands shellCommands, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setOptions");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl4 = false;
        }
        if ((n & 0x10) != 0) {
            bl5 = false;
        }
        if ((n & 0x20) != 0) {
            bl6 = false;
        }
        if ((n & 0x40) != 0) {
            bl7 = false;
        }
        if ((n & 0x80) != 0) {
            bl8 = false;
        }
        if ((n & 0x100) != 0) {
            bl9 = true;
        }
        return shellCommands.setOptions(bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9);
    }

    @ShellMethod(value="Execute a task. Put the task in double quotes. For example:\n\tx \"Lynda is a scorpio. Find news for her\" -p", key={"execute", "x"})
    @NotNull
    public String execute(@ShellOption(help="what the agent system should do") @NotNull String intent, @ShellOption(value={"-o", "--open"}, help="run in open mode, choosing a goal and using all actions that can help achieve it") boolean open, @ShellOption(value={"-p", "--showPrompts"}, help="show prompts to LLMs") boolean showPrompts, @ShellOption(value={"-r", "--showResponses"}, help="show LLM responses") boolean showLlmResponses, @ShellOption(value={"-d", "--debug"}, help="show debug info") boolean debug, @ShellOption(value={"-s", "--state"}, help="Use existing blackboard") boolean state, @ShellOption(value={"-td", "--toolDelay"}, help="Tool delay") boolean toolDelay, @ShellOption(value={"-od", "--operationDelay"}, help="Operation delay") boolean operationDelay, @ShellOption(value={"-P", "--showPlanning"}, defaultValue="true", help="show detailed planning info") boolean showPlanning) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        ShellCommands.setOptions$default(this, open, false, showPrompts, showLlmResponses, debug, state, toolDelay, operationDelay, showPlanning, 2, null);
        ProcessOptions processOptions = this.defaultProcessOptions;
        return this.executeIntent(processOptions, intent);
    }

    public static /* synthetic */ String execute$default(ShellCommands shellCommands, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: execute");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            bl4 = false;
        }
        if ((n & 0x20) != 0) {
            bl5 = false;
        }
        if ((n & 0x40) != 0) {
            bl6 = false;
        }
        if ((n & 0x80) != 0) {
            bl7 = false;
        }
        if ((n & 0x100) != 0) {
            bl8 = true;
        }
        return shellCommands.execute(string, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8);
    }

    @ShellMethod(value="Exit the application", key={"exit", "quit", "bye"})
    @NotNull
    public String exit() {
        System.out.println((Object)AnsiBuilderKt.color((String)"Exiting...", (int)this.colorPalette.getColor2()));
        this.logger.info("Shutting down application...");
        try {
            this.agentProcesses.clear();
            CompletableFuture.runAsync(() -> ShellCommands.exit$lambda$17(this));
            return AnsiBuilderKt.color((String)"Goodbye!", (int)this.colorPalette.getColor2());
        }
        catch (Exception e) {
            this.logger.warn("Error during shutdown: " + e.getMessage());
            return AnsiBuilderKt.color((String)"Goodbye! (with errors)", (int)this.colorPalette.getColor2());
        }
    }

    private String executeIntent(ProcessOptions processOptions, String intent) {
        String opt = processOptions.getVerbosity().getDebug() ? this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)processOptions) : this.objectMapper.writeValueAsString((Object)processOptions);
        this.logger.info(AnsiBuilderKt.color((String)("Created process options: " + opt), (int)this.colorPalette.getHighlight()));
        return this.runProcess(processOptions.getVerbosity(), intent, (Function0<AgentProcessExecution>)((Function0)() -> ShellCommands.executeIntent$lambda$18(this, processOptions, intent)));
    }

    private void recordAgentProcess(AgentProcess agentProcess) {
        this.agentProcesses.add(agentProcess);
        this.blackboard = agentProcess.getProcessContext().getBlackboard();
    }

    private String runProcess(Verbosity verbosity, Object basis, Function0<AgentProcessExecution> run) {
        try {
            AgentProcessExecution result = (AgentProcessExecution)run.invoke();
            this.logger.debug("Result: {}\n", (Object)result);
            this.recordAgentProcess(result.getAgentProcess());
            return FormatProcessOutputKt.formatProcessOutput(result, this.colorPalette, this.objectMapper, this.shellProperties.getLineLength());
        }
        catch (NoGoalFound ngf) {
            if (verbosity.getDebug()) {
                this.logger.info(AnsiBuilderKt.color((String)StringsKt.trimIndent((String)("\n                    Failed to choose goal:\n                        Rankings were: [" + HasInfoString.infoString$default((HasInfoString)((HasInfoString)ngf.getGoalRankings()), null, (int)0, (int)3, null) + "]\n                        Cutoff was " + this.autonomy.getProperties().getGoalConfidenceCutOff() + "\n                    ")), (int)0xBFB8B8));
            }
            return "I'm sorry. I don't know how to do that.\n";
        }
        catch (GoalNotApproved gna) {
            if (verbosity.getDebug()) {
                this.logger.info(AnsiBuilderKt.color((String)StringsKt.trimIndent((String)("\n                    Goal not approved:\n                        Rankings were: [" + HasInfoString.infoString$default((HasInfoString)((HasInfoString)gna.getGoalRankings()), null, (int)0, (int)3, null) + "]\n                    ")), (int)0xBFB8B8));
            }
            return "I'm sorry. I don't know how to do that.\n";
        }
        catch (NoAgentFound naf) {
            if (verbosity.getDebug()) {
                this.logger.info(AnsiBuilderKt.color((String)StringsKt.trimIndent((String)("\n                    Failed to choose agent:\n                        Rankings were: [" + HasInfoString.infoString$default((HasInfoString)((HasInfoString)naf.getAgentRankings()), null, (int)0, (int)3, null) + "]\n                        Cutoff was " + this.autonomy.getProperties().getAgentConfidenceCutOff() + "\n                    ")), (int)0xBFB8B8));
            }
            return "I'm sorry. I don't know how to do that.\n";
        }
        catch (ProcessExecutionStuckException pese) {
            AgentProcess agentProcess = pese.getAgentProcess();
            if (agentProcess != null) {
                AgentProcess it = agentProcess;
                boolean bl = false;
                this.recordAgentProcess(it);
            }
            return "I'm sorry. I don't know how to proceed.\n";
        }
        catch (ProcessExecutionTerminatedException pete) {
            AgentProcess agentProcess = pete.getAgentProcess();
            if (agentProcess != null) {
                AgentProcess it = agentProcess;
                boolean bl = false;
                this.recordAgentProcess(it);
            }
            return "The process was terminated. Not my fault.\n\t" + AnsiBuilderKt.color((String)pete.getDetail(), (int)this.colorPalette.getColor2()) + "\n";
        }
        catch (ProcessWaitingException pwe) {
            this.recordAgentProcess(pwe.getAgentProcess());
            AwaitableResponse awaitableResponse = this.terminalServices.handleAwaitable(pwe.getAwaitable());
            if (awaitableResponse == null) {
                return "Operation cancelled.\n";
            }
            AwaitableResponse awaitableResponse2 = awaitableResponse;
            pwe.getAwaitable().onResponse(awaitableResponse2, pwe.getAgentProcess());
            return this.runProcess(verbosity, basis, (Function0<AgentProcessExecution>)((Function0)() -> ShellCommands.runProcess$lambda$21(basis, pwe)));
        }
    }

    private static final CharSequence runs$lambda$2$lambda$1(ActionInvocation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HasInfoString.infoString$default((HasInfoString)((HasInfoString)it), null, (int)0, (int)3, null);
    }

    private static final Agent createDefaultChatbot$lambda$3(Agent $chatAgent, User it) {
        return $chatAgent;
    }

    private static final String chat$runChat(ShellCommands this$0) {
        Chatbot chatbot = this$0.chatbot;
        if (chatbot == null) {
            chatbot = this$0.createDefaultChatbot();
        }
        Chatbot chatbot2 = chatbot;
        ChatSession chatSession = Chatbot.createSession$default((Chatbot)chatbot2, null, (OutputChannel)this$0.terminalServices.outputChannel(this$0.agentPlatform), null, (int)4, null);
        return this$0.terminalServices.chat(chatSession, null, this$0.colorPalette);
    }

    private static final CharSequence agents$lambda$4(Agent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.infoString(Boolean.valueOf(true), 1);
    }

    private static final CharSequence agents$lambda$5(Agent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName() + ": " + it.getDescription();
    }

    private static final CharSequence actions$lambda$6(Action it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.infoString(Boolean.valueOf(true), 1);
    }

    private static final CharSequence actions$lambda$7(Action it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName() + ": " + it.getDescription();
    }

    private static final CharSequence conditions$lambda$8(Condition it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.infoString(Boolean.valueOf(true), 1);
    }

    private static final CharSequence goals$lambda$9(Goal it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.infoString(Boolean.valueOf(true), 1);
    }

    private static final CharSequence chooseGoal$lambda$10(Ranking it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HasInfoString.infoString$default((HasInfoString)((HasInfoString)it), (Boolean)true, (int)0, (int)2, null);
    }

    private static final CharSequence tools$lambda$14(ToolGroup it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HasInfoString.infoString$default((HasInfoString)((HasInfoString)it), (Boolean)true, (int)0, (int)2, null);
    }

    private static final int exit$lambda$17$lambda$16() {
        return 0;
    }

    private static final void exit$lambda$17(ShellCommands this$0) {
        Thread.sleep(100L);
        ExitCodeGenerator[] exitCodeGeneratorArray = new ExitCodeGenerator[]{ShellCommands::exit$lambda$17$lambda$16};
        System.exit(SpringApplication.exit((ApplicationContext)((ApplicationContext)this$0.context), (ExitCodeGenerator[])exitCodeGeneratorArray));
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final AgentProcessExecution executeIntent$lambda$18(ShellCommands this$0, ProcessOptions $processOptions, String $intent) {
        AgentProcessExecution agentProcessExecution;
        if (this$0.openMode) {
            this$0.logger.info("Executing in open mode: Trying to find appropriate goal and using all actions known to platform that can help achieve it");
            agentProcessExecution = this$0.autonomy.chooseAndAccomplishGoal($processOptions, GoalChoiceApprover.Companion.getAPPROVE_ALL(), (AgentScope)this$0.agentPlatform, MapsKt.mapOf((Pair)TuplesKt.to((Object)"userInput", (Object)new UserInput($intent))), new GoalSelectionOptions(null, null, false, 7, null));
        } else {
            this$0.logger.info("Executing in closed mode: Trying to find appropriate agent");
            agentProcessExecution = this$0.autonomy.chooseAndRunAgent($intent, $processOptions);
        }
        return agentProcessExecution;
    }

    private static final AgentProcessExecution runProcess$lambda$21(Object $basis, ProcessWaitingException $pwe) {
        return AgentProcessExecution.Companion.fromProcessStatus($basis, $pwe.getAgentProcess().run());
    }
}

