/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.ingestion;

import com.embabel.agent.rag.ingestion.ContentFormatParserUtils;
import com.embabel.agent.rag.ingestion.DirectoryParsingConfig;
import com.embabel.agent.rag.ingestion.DirectoryParsingResult;
import com.embabel.agent.rag.ingestion.HierarchicalContentReader;
import com.embabel.agent.rag.ingestion.HtmlContentParser;
import com.embabel.agent.rag.ingestion.MarkdownContentParser;
import com.embabel.agent.rag.ingestion.PlainTextContentParser;
import com.embabel.agent.rag.model.LeafSection;
import com.embabel.agent.rag.model.MaterializedDocument;
import com.embabel.agent.tools.file.FileReadTools;
import com.embabel.common.util.VisualizableTask;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.ZeroByteFileException;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.xml.sax.ContentHandler;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\u001a\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0015H\u0016J\u001e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0006\u0010'\u001a\u00020(2\u0006\u0010+\u001a\u00020\u0015J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150-2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J6\u0010.\u001a\u00020/2\u0006\u0010'\u001a\u00020(2\u0006\u00100\u001a\u00020\u00152\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u0015022\u0006\u0010)\u001a\u00020*2\u0006\u00103\u001a\u000204H\u0002J.\u00105\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00150-2\u0006\u0010)\u001a\u00020*2\u0006\u00106\u001a\u000207H\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/embabel/agent/rag/ingestion/TikaHierarchicalContentReader;", "Lcom/embabel/agent/rag/ingestion/HierarchicalContentReader;", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "parser", "Lorg/apache/tika/parser/AutoDetectParser;", "detector", "Lorg/apache/tika/detect/Detector;", "plainTextParser", "Lcom/embabel/agent/rag/ingestion/PlainTextContentParser;", "markdownParser", "Lcom/embabel/agent/rag/ingestion/MarkdownContentParser;", "htmlParser", "Lcom/embabel/agent/rag/ingestion/HtmlContentParser;", "parseUrl", "Lcom/embabel/agent/rag/model/MaterializedDocument;", "url", "", "parseResource", "resourcePath", "parseFile", "file", "Ljava/io/File;", "parseContent", "inputStream", "Ljava/io/InputStream;", "uri", "metadata", "Lorg/apache/tika/metadata/Metadata;", "getCharsetFromMetadata", "Ljava/nio/charset/Charset;", "createErrorContentRoot", "errorMessage", "parseFromDirectory", "Lcom/embabel/agent/rag/ingestion/DirectoryParsingResult;", "fileTools", "Lcom/embabel/agent/tools/file/FileReadTools;", "config", "Lcom/embabel/agent/rag/ingestion/DirectoryParsingConfig;", "filePath", "discoverFiles", "", "discoverFilesRecursive", "", "currentPath", "files", "", "depth", "", "processFiles", "startTime", "Ljava/time/Instant;", "embabel-agent-rag-tika"})
@SourceDebugExtension(value={"SMAP\nTikaHierarchicalContentReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TikaHierarchicalContentReader.kt\ncom/embabel/agent/rag/ingestion/TikaHierarchicalContentReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,527:1\n1557#2:528\n1628#2,3:529\n1755#2,3:533\n1#3:532\n*S KotlinDebug\n*F\n+ 1 TikaHierarchicalContentReader.kt\ncom/embabel/agent/rag/ingestion/TikaHierarchicalContentReader\n*L\n104#1:528\n104#1:529,3\n236#1:533,3\n*E\n"})
public final class TikaHierarchicalContentReader
implements HierarchicalContentReader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final AutoDetectParser parser = new AutoDetectParser();
    @NotNull
    private final Detector detector = (Detector)new DefaultDetector();
    @NotNull
    private final PlainTextContentParser plainTextParser = new PlainTextContentParser(this.logger);
    @NotNull
    private final MarkdownContentParser markdownParser;
    @NotNull
    private final HtmlContentParser htmlParser;

    public TikaHierarchicalContentReader() {
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        this.markdownParser = new MarkdownContentParser(logger);
        Logger logger2 = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
        this.htmlParser = new HtmlContentParser(logger2, this.plainTextParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public MaterializedDocument parseUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (StringsKt.startsWith$default((String)url, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"https://", (boolean)false, (int)2, null)) {
            this.logger.debug("Fetching URL with custom headers: {}", (Object)url);
            URI uri = new URI(url);
            URLConnection uRLConnection = uri.toURL().openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            try {
                String contentEncoding;
                String string;
                Iterable iterable;
                Object object;
                connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36");
                connection.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8");
                connection.setRequestProperty("Accept-Language", "en-US,en;q=0.9");
                connection.setRequestProperty("Accept-Encoding", "gzip, deflate");
                connection.setRequestProperty("Connection", "keep-alive");
                connection.setRequestProperty("Upgrade-Insecure-Requests", "1");
                connection.setConnectTimeout(30000);
                connection.setReadTimeout(30000);
                connection.connect();
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    this.logger.warn("Received HTTP {} for URL: {}", (Object)responseCode, (Object)url);
                    throw new IOException("Server returned HTTP response code: " + responseCode + " for URL: " + url);
                }
                org.apache.tika.metadata.Metadata metadata = new org.apache.tika.metadata.Metadata();
                String contentType = connection.getContentType();
                if (contentType != null) {
                    Object v1;
                    List parts;
                    block22: {
                        Iterable $this$mapTo$iv$iv;
                        object = new String[]{";"};
                        Iterable $this$map$iv = StringsKt.split$default((CharSequence)contentType, (String[])object, (boolean)false, (int)0, (int)6, null);
                        boolean $i$f$map = false;
                        iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            String string2 = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
                        }
                        parts = (List)destination$iv$iv;
                        metadata.set(TikaCoreProperties.CONTENT_TYPE_HINT, (String)parts.get(0));
                        $this$mapTo$iv$iv = parts;
                        for (Object e : $this$mapTo$iv$iv) {
                            String it = (String)e;
                            boolean bl = false;
                            if (!StringsKt.startsWith((String)it, (String)"charset=", (boolean)true)) continue;
                            v1 = e;
                            break block22;
                        }
                        v1 = null;
                    }
                    String charsetPart = v1;
                    if (charsetPart != null) {
                        String charset = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)charsetPart, (String)"=", null, (int)2, null))).toString();
                        metadata.set("charset", charset);
                        this.logger.debug("Server reported Content-Type: {} with charset: {}", parts.get(0), (Object)charset);
                    } else {
                        this.logger.debug("Server reported Content-Type: {}", parts.get(0));
                    }
                }
                if ((string = (contentEncoding = connection.getContentEncoding())) == null) {
                    string = "none";
                }
                this.logger.debug("Content-Encoding: {}", (Object)string);
                object = connection.getInputStream();
                Throwable throwable = null;
                try {
                    InputStream inputStream;
                    String string3;
                    InputStream rawStream = (InputStream)object;
                    boolean bl = false;
                    String string4 = contentEncoding;
                    if (string4 != null) {
                        String string5 = string4.toLowerCase(Locale.ROOT);
                        v5 = string5;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                    } else {
                        v5 = string3 = null;
                    }
                    if (Intrinsics.areEqual((Object)string3, (Object)"gzip")) {
                        this.logger.debug("Decompressing gzip content");
                        inputStream = new GZIPInputStream(rawStream);
                    } else if (Intrinsics.areEqual((Object)string3, (Object)"deflate")) {
                        this.logger.debug("Decompressing deflate content");
                        inputStream = new InflaterInputStream(rawStream);
                    } else {
                        inputStream = rawStream;
                    }
                    InputStream decompressedStream = inputStream;
                    Intrinsics.checkNotNull((Object)decompressedStream);
                    iterable = this.parseContent(decompressedStream, url, metadata);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = iterable;
                return object;
            }
            finally {
                connection.disconnect();
            }
        }
        return this.parseResource(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MaterializedDocument parseResource(@NotNull String resourcePath) {
        MaterializedDocument materializedDocument;
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Resource resource = new DefaultResourceLoader().getResource(resourcePath);
        Intrinsics.checkNotNullExpressionValue((Object)resource, (String)"getResource(...)");
        Resource resource2 = resource;
        org.apache.tika.metadata.Metadata metadata = new org.apache.tika.metadata.Metadata();
        String string = resource2.getFilename();
        if (string == null) {
            string = StringsKt.substringAfterLast$default((String)resourcePath, (char)'/', null, (int)2, null);
        }
        String filename = string;
        metadata.set("resourceName", filename);
        Closeable closeable = resource2.getInputStream();
        Throwable throwable = null;
        try {
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)inputStream);
            materializedDocument = this.parseContent(inputStream, resourcePath, metadata);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return materializedDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MaterializedDocument parseFile(@NotNull File file, @Nullable String url) {
        MaterializedDocument materializedDocument;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.logger.debug("Parsing file: {}", (Object)file.getAbsolutePath());
        org.apache.tika.metadata.Metadata metadata = new org.apache.tika.metadata.Metadata();
        metadata.set("resourceName", file.getName());
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream inputStream = (FileInputStream)closeable;
            boolean bl = false;
            String string = url;
            if (string == null) {
                String string2 = file.toURI().toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            }
            String string3 = string;
            materializedDocument = this.parseContent(inputStream, string3, metadata);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return materializedDocument;
    }

    @NotNull
    public MaterializedDocument parseContent(@NotNull InputStream inputStream, @NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.parseContent(inputStream, uri, new org.apache.tika.metadata.Metadata());
    }

    @NotNull
    public final MaterializedDocument parseContent(@NotNull InputStream inputStream, @NotNull String uri, @NotNull org.apache.tika.metadata.Metadata metadata) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        try {
            boolean bl;
            String content;
            block14: {
                String string;
                BufferedInputStream bufferedStream;
                BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : null;
                if (bufferedInputStream == null) {
                    bufferedInputStream = bufferedStream = new BufferedInputStream(inputStream);
                }
                if (metadata.get(TikaCoreProperties.CONTENT_TYPE_HINT) != null) {
                    string = metadata.get(TikaCoreProperties.CONTENT_TYPE_HINT);
                } else {
                    Object mediaType;
                    try {
                        mediaType = this.detector.detect((InputStream)bufferedStream, metadata);
                        mediaType = mediaType.toString();
                    }
                    catch (Exception e) {
                        this.logger.debug("Content type detection failed: {}, defaulting to text/plain", (Object)e.getMessage());
                        mediaType = "text/plain";
                    }
                    string = mediaType;
                }
                String detectedType = string;
                this.logger.debug("Detected content type: {}", (Object)detectedType);
                Intrinsics.checkNotNull((Object)detectedType);
                if (StringsKt.contains$default((CharSequence)detectedType, (CharSequence)"html", (boolean)false, (int)2, null)) {
                    Charset charset = this.getCharsetFromMetadata(metadata);
                    String rawContent = new String(ByteStreamsKt.readBytes((InputStream)bufferedStream), charset);
                    return this.htmlParser.parse(rawContent, metadata, uri);
                }
                String string2 = metadata.get("resourceName");
                boolean isMarkdownByExtension = string2 != null ? StringsKt.endsWith$default((String)string2, (String)".md", (boolean)false, (int)2, null) : false;
                boolean isMarkdownByType = StringsKt.contains$default((CharSequence)detectedType, (CharSequence)"markdown", (boolean)false, (int)2, null);
                if (isMarkdownByExtension || isMarkdownByType) {
                    Charset charset = this.getCharsetFromMetadata(metadata);
                    String content2 = new String(ByteStreamsKt.readBytes((InputStream)bufferedStream), charset);
                    return this.markdownParser.parse(content2, metadata, uri);
                }
                BodyContentHandler handler = new BodyContentHandler(-1);
                ParseContext parseContext = new ParseContext();
                this.parser.parse((InputStream)bufferedStream, (ContentHandler)handler, metadata, parseContext);
                String string3 = handler.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                content = string3;
                this.logger.debug("Parsed content of type: {}, length: {}", (Object)detectedType, (Object)content.length());
                Iterable $this$any$iv = StringsKt.lines((CharSequence)content);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String line = (String)element$iv;
                        boolean bl2 = false;
                        CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)line)).toString();
                        if (!new Regex("^#{1,6}\\s+.+").matches(charSequence)) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            boolean hasMarkdownHeaders = bl;
            return hasMarkdownHeaders ? this.markdownParser.parse(content, metadata, uri) : this.plainTextParser.parse(content, metadata, uri);
        }
        catch (ZeroByteFileException e) {
            this.logger.debug("Empty content detected, returning empty content root");
            return ContentFormatParserUtils.INSTANCE.createEmptyContentRoot(metadata, uri);
        }
        catch (Exception e) {
            this.logger.error("Error parsing content", (Throwable)e);
            String string = e.getMessage();
            if (string == null) {
                string = "Unknown parsing error";
            }
            return this.createErrorContentRoot(string, metadata, uri);
        }
    }

    private final Charset getCharsetFromMetadata(org.apache.tika.metadata.Metadata metadata) {
        String charsetName = metadata.get("charset");
        if (charsetName != null) {
            try {
                Charset charset = Charset.forName(charsetName);
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                return charset;
            }
            catch (IllegalCharsetNameException e) {
                this.logger.warn("Invalid charset name '{}', falling back to UTF-8", (Object)charsetName);
            }
            catch (UnsupportedCharsetException e) {
                this.logger.warn("Unsupported charset '{}', falling back to UTF-8", (Object)charsetName);
            }
        }
        return Charsets.UTF_8;
    }

    private final MaterializedDocument createErrorContentRoot(String errorMessage, org.apache.tika.metadata.Metadata metadata, String uri) {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String rootId = string;
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String leafId = string2;
        Map<String, Object> metadataMap = ContentFormatParserUtils.INSTANCE.extractMetadataMap(metadata);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"error", (Object)errorMessage), TuplesKt.to((Object)"root_document_id", (Object)rootId), TuplesKt.to((Object)"container_section_id", (Object)rootId), TuplesKt.to((Object)"leaf_section_id", (Object)leafId)};
        LeafSection errorSection = new LeafSection(leafId, uri, "Parse Error", "Error parsing content: " + errorMessage, rootId, MapsKt.plus(metadataMap, (Map)MapsKt.mapOf((Pair[])pairArray)));
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return new MaterializedDocument(rootId, uri, "Parse Error", instant, CollectionsKt.listOf((Object)errorSection), MapsKt.plus(metadataMap, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"error", (Object)errorMessage))));
    }

    @NotNull
    public DirectoryParsingResult parseFromDirectory(@NotNull FileReadTools fileTools, @NotNull DirectoryParsingConfig config) {
        DirectoryParsingResult directoryParsingResult;
        Intrinsics.checkNotNullParameter((Object)fileTools, (String)"fileTools");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Instant startTime = Instant.now();
        this.logger.info("Starting directory parsing with config: {}", (Object)config);
        try {
            List<String> files = this.discoverFiles(fileTools, config);
            this.logger.info("Discovered {} files for parsing", (Object)files.size());
            Intrinsics.checkNotNull((Object)startTime);
            directoryParsingResult = this.processFiles(fileTools, files, config, startTime);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{config.getRelativePath(), e.getMessage(), e};
            this.logger.error("Failed to parse directory '{}': {}", objectArray);
            List list = CollectionsKt.emptyList();
            Duration duration = Duration.between(startTime, Instant.now());
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
            directoryParsingResult = new DirectoryParsingResult(0, 0, 0, 1, list, duration, CollectionsKt.listOf((Object)("Directory parsing failed: " + e.getMessage())));
        }
        return directoryParsingResult;
    }

    @Nullable
    public final MaterializedDocument parseFile(@NotNull FileReadTools fileTools, @NotNull String filePath) {
        MaterializedDocument materializedDocument;
        Intrinsics.checkNotNullParameter((Object)fileTools, (String)"fileTools");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            this.logger.debug("Parsing single file: {}", (Object)filePath);
            String content = fileTools.safeReadFile(filePath);
            if (content == null) {
                this.logger.warn("Could not read file: {}", (Object)filePath);
                return null;
            }
            String string = fileTools.resolvePath(filePath).toUri().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String fileUri = string;
            MaterializedDocument result = this.parseResource(fileUri);
            this.logger.info("Successfully parsed file '{}' - {} sections extracted", (Object)filePath, (Object)CollectionsKt.count((Iterable)result.leaves()));
            materializedDocument = result;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{filePath, e.getMessage(), e};
            this.logger.error("Failed to parse file '{}': {}", objectArray);
            materializedDocument = null;
        }
        return materializedDocument;
    }

    private final List<String> discoverFiles(FileReadTools fileTools, DirectoryParsingConfig config) {
        CharSequence charSequence;
        List files = new ArrayList();
        CharSequence charSequence2 = config.getRelativePath();
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "";
        } else {
            charSequence = charSequence2;
        }
        String startPath = (String)charSequence;
        this.logger.debug("Discovering files in directory: {}", (Object)startPath);
        try {
            this.discoverFilesRecursive(fileTools, startPath, files, config, 0);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{startPath, e.getMessage(), e};
            this.logger.error("Error discovering files in '{}': {}", objectArray);
        }
        this.logger.debug("Discovered {} files in directory '{}'", (Object)files.size(), (Object)startPath);
        return files;
    }

    private final void discoverFilesRecursive(FileReadTools fileTools, String currentPath, List<String> files, DirectoryParsingConfig config, int depth) {
        if (depth > config.getMaxDepth()) {
            this.logger.debug("Reached max depth {} at path '{}'", (Object)config.getMaxDepth(), (Object)currentPath);
            return;
        }
        try {
            List entries = fileTools.listFiles(currentPath);
            for (String entry : entries) {
                String extension;
                String name;
                String fullPath;
                boolean isDirectory = StringsKt.startsWith$default((String)entry, (String)"d:", (boolean)false, (int)2, null);
                Intrinsics.checkNotNullExpressionValue((Object)entry.substring(2), (String)"substring(...)");
                String string = fullPath = ((CharSequence)currentPath).length() == 0 ? name : currentPath + "/" + name;
                if (isDirectory) {
                    if (config.getExcludedDirectories().contains(name)) {
                        this.logger.debug("Skipping excluded directory: {}", (Object)fullPath);
                        continue;
                    }
                    this.discoverFilesRecursive(fileTools, fullPath, files, config, depth + 1);
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)StringsKt.substringAfterLast((String)name, (char)'.', (String)"").toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                if (config.getIncludedExtensions().contains(extension)) {
                    Path resolvedPath = fileTools.resolvePath(fullPath);
                    if (!Files.exists(resolvedPath, new LinkOption[0])) continue;
                    long size = Files.size(resolvedPath);
                    if (size <= config.getMaxFileSize()) {
                        files.add(fullPath);
                        this.logger.trace("Added file for parsing: {} (size: {} bytes)", (Object)fullPath, (Object)size);
                        continue;
                    }
                    Object[] objectArray = new Object[]{fullPath, size, config.getMaxFileSize()};
                    this.logger.debug("Skipping large file: {} (size: {} bytes, limit: {} bytes)", objectArray);
                    continue;
                }
                this.logger.trace("Skipping file with excluded extension: {} (extension: {})", (Object)fullPath, (Object)extension);
            }
        }
        catch (Exception e) {
            this.logger.warn("Could not list files in directory '{}': {}", (Object)currentPath, (Object)e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final DirectoryParsingResult processFiles(FileReadTools fileTools, List<String> files, DirectoryParsingConfig config, Instant startTime) {
        int n;
        String error;
        int filesProcessed = 0;
        int filesSkipped = 0;
        int filesErrored = 0;
        List contentRoots = new ArrayList();
        List errors = new ArrayList();
        this.logger.info("Processing {} files for parsing", (Object)files.size());
        TikaHierarchicalContentReader.processFiles$logProgress(files, this, 0);
        Iterator iterator = ((Iterable)files).iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            int index = n2++;
            String filePath = (String)iterator.next();
            try {
                MaterializedDocument result = this.parseFile(fileTools, filePath);
                if (result != null) {
                    contentRoots.add(result);
                    ++filesProcessed;
                    var15_17 = new Object[]{filePath, index + 1, files.size(), CollectionsKt.count((Iterable)result.leaves())};
                    this.logger.debug("Successfully processed file {} ({}/{}): {} sections", var15_17);
                } else {
                    ++filesSkipped;
                    var15_17 = new Object[]{filePath, index + 1, files.size()};
                    this.logger.debug("Skipped file {} ({}/{})", var15_17);
                }
            }
            catch (Exception e) {
                ++filesErrored;
                error = "Error processing file '" + filePath + "': " + e.getMessage();
                errors.add(error);
                this.logger.error(error, (Throwable)e);
            }
            TikaHierarchicalContentReader.processFiles$logProgress(files, this, index + 1);
        }
        Duration processingTime = Duration.between(startTime, Instant.now());
        this.logger.info("Directory parsing completed in {} ms", (Object)processingTime.toMillis());
        Object object = new Object[]{filesProcessed, filesSkipped, filesErrored};
        this.logger.info("Files processed: {}, skipped: {}, errors: {}", (Object[])object);
        object = contentRoots;
        String string = "Total sections extracted: {}";
        Logger logger = this.logger;
        int n3 = 0;
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object t = iterator2.next();
            error = (MaterializedDocument)t;
            n = n3;
            boolean bl = false;
            int n4 = CollectionsKt.count((Iterable)it.leaves());
            n3 = n + n4;
        }
        n = n3;
        logger.info(string, (Object)n);
        int n5 = files.size();
        Intrinsics.checkNotNull((Object)processingTime);
        return new DirectoryParsingResult(n5, filesProcessed, filesSkipped, filesErrored, contentRoots, processingTime, errors);
    }

    private static final void processFiles$logProgress(List<String> $files, TikaHierarchicalContentReader this$0, int current) {
        VisualizableTask progress = VisualizableTask.Companion.invoke("Parsing files", current, $files.size());
        this$0.logger.info(VisualizableTask.createProgressBar$default((VisualizableTask)progress, (int)0, (int)1, null));
    }
}

