/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.ingestion;

import com.embabel.agent.rag.ingestion.ContentFormatParser;
import com.embabel.agent.rag.ingestion.ContentFormatParserUtils;
import com.embabel.agent.rag.model.LeafSection;
import com.embabel.agent.rag.model.MaterializedDocument;
import java.time.Instant;
import java.util.UUID;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tika.metadata.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@kotlin.Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/embabel/agent/rag/ingestion/PlainTextContentParser;", "Lcom/embabel/agent/rag/ingestion/ContentFormatParser;", "logger", "Lorg/slf4j/Logger;", "<init>", "(Lorg/slf4j/Logger;)V", "parse", "Lcom/embabel/agent/rag/model/MaterializedDocument;", "content", "", "metadata", "Lorg/apache/tika/metadata/Metadata;", "uri", "embabel-agent-rag-tika"})
public final class PlainTextContentParser
implements ContentFormatParser {
    @Nullable
    private final Logger logger;

    public PlainTextContentParser(@Nullable Logger logger) {
        this.logger = logger;
    }

    @Override
    @NotNull
    public MaterializedDocument parse(@NotNull String content, @NotNull Metadata metadata, @NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (StringsKt.isBlank((CharSequence)content)) {
            return ContentFormatParserUtils.INSTANCE.createEmptyContentRoot(metadata, uri);
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String rootId = string;
        String string2 = ContentFormatParserUtils.INSTANCE.extractTitle(StringsKt.lines((CharSequence)content), metadata);
        if (string2 == null) {
            string2 = "Document";
        }
        String title = string2;
        String string3 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        LeafSection leafSection = ContentFormatParserUtils.INSTANCE.createLeafSection(string3, title, ((Object)StringsKt.trim((CharSequence)content)).toString(), rootId, uri, metadata, rootId);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return new MaterializedDocument(rootId, uri, title, instant, CollectionsKt.listOf((Object)leafSection), ContentFormatParserUtils.INSTANCE.extractMetadataMap(metadata));
    }
}

