/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.ingestion;

import com.embabel.agent.rag.ingestion.ContentFormatParser;
import com.embabel.agent.rag.ingestion.ContentFormatParserUtils;
import com.embabel.agent.rag.model.MaterializedDocument;
import com.embabel.agent.rag.model.NavigableSection;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/embabel/agent/rag/ingestion/MarkdownContentParser;", "Lcom/embabel/agent/rag/ingestion/ContentFormatParser;", "logger", "Lorg/slf4j/Logger;", "<init>", "(Lorg/slf4j/Logger;)V", "parse", "Lcom/embabel/agent/rag/model/MaterializedDocument;", "content", "", "metadata", "Lorg/apache/tika/metadata/Metadata;", "uri", "embabel-agent-rag-tika"})
@SourceDebugExtension(value={"SMAP\nMarkdownContentParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownContentParser.kt\ncom/embabel/agent/rag/ingestion/MarkdownContentParser\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n648#2,5:143\n1#3:148\n774#4:149\n865#4,2:150\n1863#4,2:152\n*S KotlinDebug\n*F\n+ 1 MarkdownContentParser.kt\ncom/embabel/agent/rag/ingestion/MarkdownContentParser\n*L\n62#1:143,5\n80#1:149\n80#1:150,2\n80#1:152,2\n*E\n"})
public final class MarkdownContentParser
implements ContentFormatParser {
    @NotNull
    private final Logger logger;

    public MarkdownContentParser(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MaterializedDocument parse(@NotNull String content, @NotNull org.apache.tika.metadata.Metadata metadata, @NotNull String uri) {
        String rootId;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        List lines = StringsKt.lines((CharSequence)content);
        List leafSections = new ArrayList();
        StringBuilder currentSection = new StringBuilder();
        String currentTitle = "";
        String sectionId = "";
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String parentId = rootId = string;
        Map sectionStack = new LinkedHashMap();
        for (String line : lines) {
            if (StringsKt.startsWith$default((String)line, (String)"#", (boolean)false, (int)2, null)) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                String string2;
                String string3;
                int it22;
                block16: {
                    if (!StringsKt.isBlank((CharSequence)currentTitle)) {
                        String string4 = currentSection.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                        leafSections.add(ContentFormatParserUtils.INSTANCE.createLeafSection(sectionId, currentTitle, ((Object)StringsKt.trim((CharSequence)string4)).toString(), parentId, uri, metadata, rootId));
                    }
                    String $this$takeWhile$iv = line;
                    boolean $i$f$takeWhile = false;
                    int n = $this$takeWhile$iv.length();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        it22 = $this$takeWhile$iv.charAt(index$iv);
                        int n2 = 0;
                        if (it22 == 35) continue;
                        String it22 = $this$takeWhile$iv;
                        n2 = 0;
                        String string5 = it22.substring(n2, index$iv);
                        string3 = string5;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                        break block16;
                    }
                    string3 = $this$takeWhile$iv;
                }
                int level = string3.length();
                String string6 = line.substring(level);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                currentTitle = ((Object)StringsKt.trim((CharSequence)string6)).toString();
                sectionId = UUID.randomUUID().toString();
                StringsKt.clear((StringBuilder)currentSection);
                if (level == 1) {
                    string2 = rootId;
                } else if (level > 1) {
                    String string7;
                    block17: {
                        Iterator index$iv = ((Iterable)RangesKt.downTo((int)(level - 1), (int)1)).iterator();
                        while (index$iv.hasNext()) {
                            int it32 = ((IntIterator)index$iv).nextInt();
                            boolean bl = false;
                            String it32 = (String)sectionStack.get(it32);
                            if (it32 == null) continue;
                            string7 = it32;
                            break block17;
                        }
                        string7 = string2 = null;
                    }
                    if (string7 == null) {
                        string2 = rootId;
                    }
                } else {
                    string2 = rootId;
                }
                parentId = string2;
                Integer $i$f$takeWhile = level;
                sectionStack.put($i$f$takeWhile, sectionId);
                Iterable $this$filter$iv = sectionStack.keySet();
                boolean $i$f$filter = false;
                Iterable index$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    int it = ((Number)element$iv$iv).intValue();
                    boolean bl = false;
                    if (!(it > level)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it22 = ((Number)element$iv).intValue();
                    boolean bl = false;
                    sectionStack.remove(it22);
                }
                continue;
            }
            if (!(!StringsKt.isBlank((CharSequence)line)) && !(((CharSequence)currentSection).length() > 0)) continue;
            currentSection.append(line).append('\n');
        }
        if (!StringsKt.isBlank((CharSequence)currentTitle)) {
            String string8 = currentSection.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(...)");
            leafSections.add(ContentFormatParserUtils.INSTANCE.createLeafSection(sectionId, currentTitle, ((Object)StringsKt.trim((CharSequence)string8)).toString(), parentId, uri, metadata, rootId));
        }
        if (leafSections.isEmpty() && !StringsKt.isBlank((CharSequence)content)) {
            String string9 = ContentFormatParserUtils.INSTANCE.extractTitle(lines, metadata);
            if (string9 == null) {
                string9 = "Document";
            }
            String title = string9;
            String string10 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toString(...)");
            leafSections.add(ContentFormatParserUtils.INSTANCE.createLeafSection(string10, title, ((Object)StringsKt.trim((CharSequence)content)).toString(), rootId, uri, metadata, rootId));
        }
        this.logger.debug("Created {} leaf sections from markdown content", (Object)leafSections.size());
        String string11 = ContentFormatParserUtils.INSTANCE.extractTitle(lines, metadata);
        if (string11 == null && (string11 = metadata.get("resourceName")) == null) {
            string11 = "Document";
        }
        String documentTitle = string11;
        List<NavigableSection> hierarchicalSections = ContentFormatParserUtils.INSTANCE.buildHierarchy(leafSections, rootId);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return new MaterializedDocument(rootId, uri, documentTitle, instant, hierarchicalSections, ContentFormatParserUtils.INSTANCE.extractMetadataMap(metadata));
    }
}

