/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.rag.ingestion;

import com.embabel.agent.rag.model.DefaultMaterializedContainerSection;
import com.embabel.agent.rag.model.LeafSection;
import com.embabel.agent.rag.model.MaterializedDocument;
import com.embabel.agent.rag.model.NavigableSection;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.tika.metadata.TikaCoreProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\u000e\u001a\u00020\u0007J\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00162\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0007\u00a8\u0006\u001a"}, d2={"Lcom/embabel/agent/rag/ingestion/ContentFormatParserUtils;", "", "<init>", "()V", "createLeafSection", "Lcom/embabel/agent/rag/model/LeafSection;", "id", "", "title", "content", "parentId", "url", "metadata", "Lorg/apache/tika/metadata/Metadata;", "rootId", "buildHierarchy", "", "Lcom/embabel/agent/rag/model/NavigableSection;", "sections", "extractTitle", "lines", "extractMetadataMap", "", "createEmptyContentRoot", "Lcom/embabel/agent/rag/model/MaterializedDocument;", "uri", "embabel-agent-rag-tika"})
@SourceDebugExtension(value={"SMAP\nContentFormatParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentFormatParser.kt\ncom/embabel/agent/rag/ingestion/ContentFormatParserUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,204:1\n1485#2:205\n1510#2,3:206\n1513#2,3:216\n1557#2:219\n1628#2,3:220\n1557#2:229\n1628#2,3:230\n381#3,7:209\n1#4:223\n648#5,5:224\n*S KotlinDebug\n*F\n+ 1 ContentFormatParser.kt\ncom/embabel/agent/rag/ingestion/ContentFormatParserUtils\n*L\n92#1:205\n92#1:206,3\n92#1:216,3\n140#1:219\n140#1:220,3\n125#1:229\n125#1:230,3\n92#1:209,7\n160#1:224,5\n*E\n"})
public final class ContentFormatParserUtils {
    @NotNull
    public static final ContentFormatParserUtils INSTANCE = new ContentFormatParserUtils();

    private ContentFormatParserUtils() {
    }

    @NotNull
    public final LeafSection createLeafSection(@NotNull String id, @NotNull String title, @NotNull String content, @Nullable String parentId, @Nullable String url, @NotNull org.apache.tika.metadata.Metadata metadata, @NotNull String rootId) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)rootId, (String)"rootId");
        Map metadataMap = MapsKt.toMutableMap(this.extractMetadataMap(metadata));
        metadataMap.put("root_document_id", rootId);
        String string = parentId;
        if (string == null) {
            string = rootId;
        }
        metadataMap.put("container_section_id", string);
        metadataMap.put("leaf_section_id", id);
        return new LeafSection(id, url, title, content, parentId, metadataMap);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<NavigableSection> buildHierarchy(@NotNull List<LeafSection> sections, @NotNull String rootId) {
        void $this$mapTo$iv$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(sections, (String)"sections");
        Intrinsics.checkNotNullParameter((Object)rootId, (String)"rootId");
        if (sections.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$groupBy$iv = sections;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            LeafSection it = (LeafSection)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getParentId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object sectionsByParent = destination$iv$iv;
        List list = (List)sectionsByParent.get(rootId);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List topLevelSections = list;
        Iterable $this$map$iv = topLevelSections;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LeafSection bl = (LeafSection)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(ContentFormatParserUtils.buildHierarchy$buildSection((Map<String, ? extends List<LeafSection>>)sectionsByParent, (LeafSection)it));
        }
        return (List)destination$iv$iv2;
    }

    @Nullable
    public final String extractTitle(@NotNull List<String> lines, @NotNull org.apache.tika.metadata.Metadata metadata) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        String string = metadata.get(TikaCoreProperties.TITLE);
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        for (String line : lines) {
            if (StringsKt.startsWith$default((String)line, (String)"#", (boolean)false, (int)2, null)) {
                String string2;
                String string3;
                block4: {
                    string3 = line;
                    String $this$takeWhile$iv = line;
                    boolean $i$f$takeWhile = false;
                    int n = $this$takeWhile$iv.length();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        char it = $this$takeWhile$iv.charAt(index$iv);
                        boolean bl = false;
                        if (it == '#') continue;
                        String string4 = $this$takeWhile$iv;
                        int n2 = 0;
                        String string5 = string4.substring(n2, index$iv);
                        string2 = string5;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                        break block4;
                    }
                    string2 = $this$takeWhile$iv;
                }
                int n = string2.length();
                String string6 = string3.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                return ((Object)StringsKt.trim((CharSequence)string6)).toString();
            }
            if (!(!StringsKt.isBlank((CharSequence)line))) continue;
            return ((Object)StringsKt.trim((CharSequence)StringsKt.take((String)line, (int)50))).toString();
        }
        return null;
    }

    @NotNull
    public final Map<String, Object> extractMetadataMap(@NotNull org.apache.tika.metadata.Metadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Map map = new LinkedHashMap();
        Iterator iterator = ArrayIteratorKt.iterator((Object[])metadata.names());
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            String value = metadata.get(name);
            if (value == null) continue;
            map.put(name, value);
        }
        return map;
    }

    @NotNull
    public final MaterializedDocument createEmptyContentRoot(@NotNull org.apache.tika.metadata.Metadata metadata, @NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = metadata.get("resourceName");
        if (string2 == null) {
            string2 = "Empty Document";
        }
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return new MaterializedDocument(string, uri, string2, instant, CollectionsKt.emptyList(), this.extractMetadataMap(metadata));
    }

    /*
     * WARNING - void declaration
     */
    private static final NavigableSection buildHierarchy$buildSection(Map<String, ? extends List<LeafSection>> sectionsByParent, LeafSection section) {
        NavigableSection navigableSection;
        List children;
        List list = sectionsByParent.get(section.getId());
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if ((children = list).isEmpty()) {
            navigableSection = (NavigableSection)section;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            LeafSection preambleSection;
            Object preambleId;
            List childSections = new ArrayList();
            if (!StringsKt.isBlank((CharSequence)section.getContent())) {
                Map map;
                preambleId = section.getId() + "_preamble";
                Map $this$buildHierarchy_u24buildSection_u24lambda_u241 = map = MapsKt.toMutableMap((Map)section.getMetadata());
                boolean bl = false;
                $this$buildHierarchy_u24buildSection_u24lambda_u241.put("leaf_section_id", preambleId);
                Map preambleMetadata = map;
                preambleSection = new LeafSection((String)preambleId, section.getUri(), section.getTitle(), section.getContent(), section.getId(), preambleMetadata);
                childSections.add(preambleSection);
            }
            preambleId = children;
            List list2 = childSections;
            boolean $i$f$map = false;
            preambleSection = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LeafSection leafSection = (LeafSection)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ContentFormatParserUtils.buildHierarchy$buildSection(sectionsByParent, (LeafSection)it));
            }
            list2.addAll((List)destination$iv$iv);
            navigableSection = (NavigableSection)new DefaultMaterializedContainerSection(section.getId(), section.getUri(), section.getTitle(), childSections, section.getParentId(), section.getMetadata());
        }
        return navigableSection;
    }
}

